/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.lock.model;

import cn.lingyangwl.framework.lock.exception.LockException;
import cn.lingyangwl.framework.lock.model.LockTemplate;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.redis.util.RedisLockRegistry;

public class IntegrationRedisLock
extends LockTemplate {
    private static final Logger log = LoggerFactory.getLogger(IntegrationRedisLock.class);
    private final Lock lock;

    public IntegrationRedisLock(String lockKey, RedisLockRegistry redisLockRegistry) {
        super(lockKey);
        Assert.notNull((Object)redisLockRegistry, (String)"redisLockRegistry is null");
        this.lock = redisLockRegistry.obtain((Object)lockKey);
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public void lock() {
        try {
            this.lock.lock();
        }
        catch (Exception e) {
            log.error("get lock fail, msg: {}", (Object)e.getMessage());
            throw new LockException("get lock fail");
        }
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException("IntegrationRedisLock no support isLocked");
    }

    @Override
    public boolean tryLock(long waitTime, TimeUnit unit) {
        try {
            return this.lock.tryLock(waitTime, unit);
        }
        catch (Exception e) {
            log.error("get lock fail, msg: {}", (Object)e.getMessage());
            throw new LockException("get lock fail");
        }
    }
}

