/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.lock.aspect;

import cn.lingyangwl.framework.core.utils.spring.SpringUtils;
import cn.lingyangwl.framework.lock.annotation.DistributedLock;
import cn.lingyangwl.framework.lock.exception.LockException;
import cn.lingyangwl.framework.lock.manager.ILockManager;
import cn.lingyangwl.framework.lock.model.ILock;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DistributedLockAspect {
    private static final Logger log = LoggerFactory.getLogger(DistributedLockAspect.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="@annotation(distributedLock)")
    public Object lock(ProceedingJoinPoint joinPoint, DistributedLock distributedLock) throws Throwable {
        Object output = null;
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        Object[] args = joinPoint.getArgs();
        LocalVariableTableParameterNameDiscoverer localVariableTable = new LocalVariableTableParameterNameDiscoverer();
        String[] paraNameArr = localVariableTable.getParameterNames(method);
        SpelExpressionParser parser = new SpelExpressionParser();
        StandardEvaluationContext context = new StandardEvaluationContext();
        for (int i = 0; i < Objects.requireNonNull(paraNameArr).length; ++i) {
            context.setVariable(paraNameArr[i], args[i]);
        }
        String lockKey = distributedLock.lockKey();
        if (lockKey.matches("^#.*.$")) {
            lockKey = (String)parser.parseExpression(lockKey).getValue((EvaluationContext)context, String.class);
        }
        String lockBeanName = distributedLock.beanName();
        long waitTime = distributedLock.waitTime();
        TimeUnit unit = distributedLock.unit();
        int lockFailCode = distributedLock.lockFailCode();
        String lockFailMessage = distributedLock.lockFailMessage();
        Assert.notEmpty((String)lockBeanName, (String)"lock bean name is empty");
        ILockManager lockService = (ILockManager)SpringUtils.getBean((String)lockBeanName, ILockManager.class);
        ILock lock = null;
        try {
            lock = lockService.getLock(lockKey);
            boolean isGetLock = lock.tryLock(waitTime, unit);
            if (!isGetLock) {
                throw new LockException(lockFailCode, lockFailMessage);
            }
            output = joinPoint.proceed();
        }
        finally {
            if (lock != null) {
                lock.unlock();
            }
        }
        return output;
    }
}

