/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.lock;

import cn.lingyangwl.framework.lock.CuratorProperties;
import cn.lingyangwl.framework.lock.manager.CuratorManager;
import java.util.concurrent.CountDownLatch;
import javax.annotation.Resource;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={CuratorFramework.class})
@EnableConfigurationProperties(value={CuratorProperties.class})
public class LyLockCuratorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LyLockCuratorAutoConfiguration.class);
    @Resource
    private CuratorProperties curatorProperties;

    @Bean(name={"curatorService"})
    @ConditionalOnMissingBean(value={CuratorManager.class})
    public CuratorManager curatorService(CuratorFramework curatorFramework) {
        return new CuratorManager(curatorFramework);
    }

    @Bean
    @ConditionalOnMissingBean(value={CuratorFramework.class})
    public CuratorFramework curatorFramework() {
        CuratorProperties.RetryPolicy retryPolicy = this.curatorProperties.getRetryPolicy();
        ExponentialBackoffRetry policy = new ExponentialBackoffRetry((int)retryPolicy.getBaseSleepTime().toMillis(), retryPolicy.getMaxRetries());
        String connectString = this.curatorProperties.getAddress();
        long connectionTimeout = this.curatorProperties.getSessionTimeout().toMillis();
        long sessionTimeout = this.curatorProperties.getSessionTimeout().toMillis();
        CuratorFramework curatorFramework = CuratorFrameworkFactory.builder().connectString(connectString).connectionTimeoutMs((int)connectionTimeout).sessionTimeoutMs((int)sessionTimeout).retryPolicy((RetryPolicy)policy).build();
        CountDownLatch waitConnectionLatch = new CountDownLatch(1);
        curatorFramework.getConnectionStateListenable().addListener((client, newState) -> {
            if (newState == ConnectionState.CONNECTED) {
                log.info("curator connection zookeeper success\uff01");
                waitConnectionLatch.countDown();
            }
        });
        log.info("curator connection zookeeper......");
        curatorFramework.start();
        try {
            waitConnectionLatch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return curatorFramework;
    }
}

