package cn.lingyangwl.framework.lock.manager;

import cn.lingyangwl.framework.lock.model.ILock;
import cn.lingyangwl.framework.lock.model.IntegrationRedisLock;
import org.springframework.integration.redis.util.RedisLockRegistry;

/**
 * @author shenguangyang
 */
public class IntegrationRedisManager implements ILockManager {

    private final RedisLockRegistry redisLockRegistry;

    public IntegrationRedisManager(RedisLockRegistry redisLockRegistry) {
        this.redisLockRegistry = redisLockRegistry;
    }

    @Override
    public ILock getLock(String lockKey) {
        return new IntegrationRedisLock(lockKey, redisLockRegistry);
    }
}
