/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.ip2region.handler;

import cn.lingyangwl.framework.ip2region.handler.Ip2RegionOfflineHandler;
import cn.lingyangwl.framework.ip2region.model.AddressInfo;
import com.maxmind.geoip2.DatabaseReader;
import java.net.InetAddress;
import org.apache.commons.lang3.StringUtils;

public class Geoip2Handler
implements Ip2RegionOfflineHandler {
    private final String ip;
    private final DatabaseReader reader;

    public Geoip2Handler(String ip, DatabaseReader reader) {
        this.ip = ip;
        this.reader = reader;
    }

    @Override
    public String getCountry() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return "";
        }
        return (String)this.reader.city(InetAddress.getByName(this.ip)).getCountry().getNames().get("zh-CN");
    }

    @Override
    public String getProvince() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return "";
        }
        return (String)this.reader.city(InetAddress.getByName(this.ip)).getMostSpecificSubdivision().getNames().get("zh-CN");
    }

    @Override
    public String getCity() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return "";
        }
        return (String)this.reader.city(InetAddress.getByName(this.ip)).getCity().getNames().get("zh-CN");
    }

    @Override
    public AddressInfo getAddress() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return new AddressInfo();
        }
        InetAddress inetAddress = InetAddress.getByName(this.ip);
        String country = (String)this.reader.city(inetAddress).getCountry().getNames().get("zh-CN");
        String province = (String)this.reader.city(inetAddress).getMostSpecificSubdivision().getNames().get("zh-CN");
        String city = (String)this.reader.city(inetAddress).getCity().getNames().get("zh-CN");
        return AddressInfo.builder().city(city).province(province).country(country).build();
    }

    @Override
    public Double getLongitude() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return null;
        }
        return this.reader.city(InetAddress.getByName(this.ip)).getLocation().getLongitude();
    }

    @Override
    public Double getLatitude() throws Exception {
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return null;
        }
        return this.reader.city(InetAddress.getByName(this.ip)).getLocation().getLatitude();
    }
}

