package cn.lingyangwl.framework.ip2region.handler;

import cn.lingyangwl.framework.ip2region.model.AddressInfo;

/**
 * @author shenguangyang
 */
public interface Ip2RegionOfflineHandler {
    /**
     * 获取国家
     */
    String getCountry() throws Exception;

    /**
     * 获得省份
     */
    String getProvince() throws Exception;

    /**
     * 获得城市
     */
    String getCity() throws Exception;

    /**
     * 获得经度
     */
    default Double getLongitude() throws Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * 获得纬度
     */
    default Double getLatitude() throws Exception {
        throw new UnsupportedOperationException();
    }

    /**
     * 获取地址
     */
    AddressInfo getAddress() throws Exception;
}
