/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.ip2region.handler;

import cn.lingyangwl.framework.ip2region.handler.Ip2RegionOfflineHandler;
import cn.lingyangwl.framework.ip2region.model.AddressInfo;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.lionsoul.ip2region.xdb.Searcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ip2RegionHandler
implements Ip2RegionOfflineHandler {
    private static final Logger log = LoggerFactory.getLogger(Ip2RegionHandler.class);
    private final String ip;
    private final byte[] vectorIndex;
    private final String databasePath;

    public Ip2RegionHandler(String ip, byte[] vectorIndex, String databasePath) {
        this.ip = ip;
        this.vectorIndex = vectorIndex;
        this.databasePath = databasePath;
    }

    @Override
    public String getCountry() throws Exception {
        return this.getAddress().getCountry();
    }

    @Override
    public String getProvince() throws Exception {
        return this.getAddress().getProvince();
    }

    @Override
    public String getCity() throws Exception {
        return this.getAddress().getCity();
    }

    @Override
    public AddressInfo getAddress() throws Exception {
        Searcher searcher;
        if (StringUtils.isEmpty((CharSequence)this.ip)) {
            return new AddressInfo();
        }
        try {
            searcher = Searcher.newWithVectorIndex((String)this.databasePath, (byte[])this.vectorIndex);
        }
        catch (Exception e) {
            log.error("failed to create vectorIndex cached searcher with [{}]: {}", (Object)this.databasePath, (Object)e.getMessage());
            throw e;
        }
        try {
            String[] split;
            long sTime = System.nanoTime();
            String region = searcher.search(this.ip);
            long cost = TimeUnit.NANOSECONDS.toMicros(System.nanoTime() - sTime);
            log.debug("ip: {}, region: {}, ioCount: {}, took: {} \u03bcs", new Object[]{this.ip, region, searcher.getIOCount(), cost});
            if (StringUtils.isNotEmpty((CharSequence)region) && (split = region.split("\\|")).length >= 5) {
                AddressInfo addressInfo = AddressInfo.builder().country(split[0]).province(split[2]).city(split[3]).isp(split[4]).build();
                return addressInfo;
            }
        }
        catch (Exception e) {
            log.error("failed to search({}): {}", (Object)this.ip, (Object)e.getMessage());
            throw e;
        }
        finally {
            searcher.close();
        }
        return new AddressInfo();
    }
}

