/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.ip2region.factory;

import cn.lingyangwl.framework.core.http.HttpRequestManager;
import cn.lingyangwl.framework.core.http.HttpRequestServletManager;
import cn.lingyangwl.framework.core.utils.IpUtils;
import cn.lingyangwl.framework.ip2region.config.properties.LyIpProperties;
import cn.lingyangwl.framework.ip2region.factory.Ip2RegionOfflineFactory;
import cn.lingyangwl.framework.ip2region.handler.Ip2RegionHandler;
import cn.lingyangwl.framework.ip2region.handler.Ip2RegionOfflineHandler;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.lionsoul.ip2region.xdb.Searcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={Searcher.class})
@ConditionalOnProperty(prefix="lingyang-framework.ip2region", value={"offline.type"}, havingValue="ip2region")
public class Ip2RegionOffline
implements Ip2RegionOfflineFactory {
    private static final Logger log = LoggerFactory.getLogger(Ip2RegionOffline.class);
    @Resource
    private LyIpProperties lyIpProperties;
    private byte[] vectorIndex;

    @PostConstruct
    public void init() {
        String databasePath = this.lyIpProperties.getOffline().getDatabasePath();
        try {
            this.vectorIndex = Searcher.loadVectorIndexFromFile((String)databasePath);
        }
        catch (Exception e) {
            log.error("failed to load vector index from [{}]: ", (Object)databasePath, (Object)e);
        }
    }

    @Override
    public Ip2RegionOfflineHandler create(HttpServletRequest request) {
        String ip = IpUtils.getRequestIp((HttpRequestManager)new HttpRequestServletManager(request));
        String databasePath = this.lyIpProperties.getOffline().getDatabasePath();
        return new Ip2RegionHandler(ip, this.vectorIndex, databasePath);
    }

    @Override
    public Ip2RegionOfflineHandler create(String ip) {
        String databasePath = this.lyIpProperties.getOffline().getDatabasePath();
        return new Ip2RegionHandler(ip, this.vectorIndex, databasePath);
    }
}

