/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.ip2region.factory;

import cn.lingyangwl.framework.core.http.HttpRequestManager;
import cn.lingyangwl.framework.core.http.HttpRequestServletManager;
import cn.lingyangwl.framework.core.utils.IpUtils;
import cn.lingyangwl.framework.ip2region.factory.Ip2RegionOfflineFactory;
import cn.lingyangwl.framework.ip2region.handler.Geoip2Handler;
import cn.lingyangwl.framework.ip2region.handler.Ip2RegionOfflineHandler;
import com.maxmind.geoip2.DatabaseReader;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={DatabaseReader.class})
@ConditionalOnProperty(prefix="lingyang-framework.ip2region", value={"offline.type"}, havingValue="geoip2")
public class Geoip2Offline
implements Ip2RegionOfflineFactory {
    @Resource
    private DatabaseReader reader;

    @Override
    public Ip2RegionOfflineHandler create(HttpServletRequest request) {
        String ip = IpUtils.getRequestIp((HttpRequestManager)new HttpRequestServletManager(request));
        return new Geoip2Handler(ip, this.reader);
    }

    @Override
    public Ip2RegionOfflineHandler create(String ip) {
        return new Geoip2Handler(ip, this.reader);
    }
}

