package cn.lingyangwl.framework.ip2region.factory;

import cn.lingyangwl.framework.core.constant.LyCoreConstants;
import cn.lingyangwl.framework.core.http.HttpRequestServletManager;
import cn.lingyangwl.framework.ip2region.constants.IpOfflineType;
import cn.lingyangwl.framework.ip2region.handler.Geoip2Handler;
import cn.lingyangwl.framework.ip2region.handler.Ip2RegionOfflineHandler;
import com.maxmind.geoip2.DatabaseReader;
import cn.lingyangwl.framework.core.utils.IpUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;

/**
 * @author shenguangyang
 */
@Component
@ConditionalOnClass(DatabaseReader.class)
@ConditionalOnProperty(prefix = LyCoreConstants.PROPERTIES_PRE + "ip2region", value = "offline.type", havingValue = IpOfflineType.GEOIP2)
public class Geoip2Offline implements Ip2RegionOfflineFactory {
    @Resource
    private DatabaseReader reader;

    @Override
    public Ip2RegionOfflineHandler create(HttpServletRequest request) {
        String ip = IpUtils.getRequestIp(new HttpRequestServletManager(request));
        return new Geoip2Handler(ip, reader);
    }

    @Override
    public Ip2RegionOfflineHandler create(String ip) {
        return new Geoip2Handler(ip, reader);
    }
}
