package cn.lingyangwl.framework.ip2region.config.properties;

import cn.lingyangwl.framework.core.constant.LyCoreConstants;
import cn.lingyangwl.framework.ip2region.constants.IpOfflineType;
import lombok.Getter;
import lombok.Setter;
import org.springframework.boot.context.properties.ConfigurationProperties;

import javax.annotation.PostConstruct;
import java.util.Objects;

/**
 * @author shenguangyang
 */
@Getter
@Setter
@ConfigurationProperties(prefix = LyCoreConstants.PROPERTIES_PRE + "ip2region")
public class LyIpProperties {
    private Offline offline;

    @PostConstruct
    public void check() {
        if (Objects.nonNull(offline)) {
            if (!IpOfflineType.GEOIP2.equals(offline.getType()) &&
                    !IpOfflineType.IP2REGION.equals(offline.getType())) {
                throw new RuntimeException("property [ ip2region.type ] value is not exist, " +
                        "only support [ " + IpOfflineType.GEOIP2 + "|" + IpOfflineType.IP2REGION + " ]");
            }
        }
    }

    @Getter
    @Setter
    public static class Offline {
        /**
         * 离线获取ip类型, 默认是通过 geoip2获取
         */
        private String type = IpOfflineType.GEOIP2;
        /**
         * 这里就是填写离线资源包的地址
         * <p>
         * 这里默认采用的是MaxMind GeoIP2
         * <a href="https://www.maxmind.com/en/home">官网</a> <br/>
         * <a href="https://dev.maxmind.com/geoip/geoip2/geolite2/#Downloads">离线资源包</a> <br/>
         */
        private String databasePath;
    }
}
