package cn.lingyangwl.framework.ip2region;

import cn.lingyangwl.framework.ip2region.config.Geoip2Config;
import cn.lingyangwl.framework.ip2region.config.properties.LyIpProperties;
import cn.lingyangwl.framework.ip2region.factory.Geoip2Offline;
import cn.lingyangwl.framework.ip2region.factory.Ip2RegionOffline;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@Slf4j
@AutoConfiguration
@Import({
        Geoip2Config.class, Geoip2Offline.class, Ip2RegionOffline.class
})
@EnableConfigurationProperties({
        LyIpProperties.class
})
public class LyIp2regionAutoConfiguration {

    @PostConstruct
    public void init() {
        log.info("init {}", this.getClass().getName());
    }
}
