/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.idgenerator.config;

import cn.lingyangwl.framework.idgenerator.IdGeneratorHandler;
import cn.lingyangwl.framework.idgenerator.config.IdGeneratorProperties;
import com.github.yitter.contract.IdGeneratorOptions;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IdGeneratorProperties.class})
public class IdGeneratorConfig {
    @Resource
    IdGeneratorProperties idGeneratorProperties;
    @Autowired(required=false)
    IdGeneratorHandler idGeneratorHandler;

    @Bean
    @ConditionalOnMissingBean(value={IdGeneratorOptions.class})
    public IdGeneratorOptions idGeneratorOptions() {
        IdGeneratorOptions options = new IdGeneratorOptions();
        options.BaseTime = this.idGeneratorProperties.getBaseTime();
        options.MaxSeqNumber = this.idGeneratorProperties.getMaxSeqNumber();
        options.MinSeqNumber = this.idGeneratorProperties.getMinSeqNumber();
        options.SeqBitLength = this.idGeneratorProperties.getSeqBitLength();
        options.WorkerId = this.idGeneratorProperties.getWorkerId();
        options.WorkerIdBitLength = this.idGeneratorProperties.getWorkerIdBitLength();
        if (this.idGeneratorHandler != null) {
            options.WorkerId = this.idGeneratorHandler.getWorkerId();
        }
        return options;
    }
}

