/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.idgenerator.config;

import cn.lingyangwl.framework.idgenerator.IdGeneratorHandler;
import cn.lingyangwl.framework.idgenerator.config.IdGeneratorProperties;
import com.github.yitter.contract.IdGeneratorOptions;
import com.github.yitter.idgen.YitIdHelper;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={IdGeneratorProperties.class})
public class IdGeneratorConfig {
    @Resource
    IdGeneratorProperties idGeneratorProperties;
    @Autowired(required=false)
    IdGeneratorHandler idGeneratorHandler;

    @PostConstruct
    public void init() {
        IdGeneratorOptions options = new IdGeneratorOptions();
        options.BaseTime = this.idGeneratorProperties.getBaseTime();
        options.MaxSeqNumber = this.idGeneratorProperties.getMaxSeqNumber();
        options.MinSeqNumber = this.idGeneratorProperties.getMinSeqNumber();
        options.SeqBitLength = this.idGeneratorProperties.getSeqBitLength();
        options.WorkerId = this.idGeneratorProperties.getWorkerId();
        options.WorkerIdBitLength = this.idGeneratorProperties.getWorkerIdBitLength();
        if (this.idGeneratorHandler != null) {
            options.WorkerId = this.idGeneratorHandler.getWorkerId();
        }
        YitIdHelper.setIdGenerator((IdGeneratorOptions)options);
    }
}

