package cn.lingyangwl.framework.idgenerator;

import cn.lingyangwl.framework.idgenerator.config.IdGeneratorConfig;
import cn.lingyangwl.framework.idgenerator.config.IdGeneratorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@AutoConfiguration
@EnableConfigurationProperties(IdGeneratorProperties.class)
@ImportAutoConfiguration(IdGeneratorConfig.class)
public class LyIdGeneratorAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LyIdGeneratorAutoConfiguration.class);

    @PostConstruct
    public void init() {
        log.info("init {}", this.getClass().getName());
    }
}
