/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.file.upload.local;

import cn.hutool.core.io.FileUtil;
import cn.lingyangwl.framework.file.upload.exception.MergeChunksException;
import cn.lingyangwl.framework.file.upload.local.ILocalBreakpointResumeManager;
import cn.lingyangwl.framework.file.upload.local.UploadFilePathManager;
import cn.lingyangwl.framework.file.upload.local.callback.LocalBreakpointResumeCallback;
import cn.lingyangwl.framework.file.upload.local.enums.FileUploadStateEnum;
import cn.lingyangwl.framework.file.upload.local.model.BreakpointRegister;
import cn.lingyangwl.framework.file.upload.local.model.BreakpointRegisterDTO;
import cn.lingyangwl.framework.file.upload.local.model.FileInfoOfFind;
import cn.lingyangwl.framework.file.upload.local.model.FileRegisterInfo;
import cn.lingyangwl.framework.file.upload.local.model.MergeChunks;
import cn.lingyangwl.framework.file.upload.local.model.MergeChunksDTO;
import cn.lingyangwl.framework.file.upload.local.model.UploadChunk;
import cn.lingyangwl.framework.file.upload.local.model.UploadChunkDTO;
import cn.lingyangwl.framework.tool.core.file.FileUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.compress.utils.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.unit.DataSize;

@Component
public class LocalBreakpointResumeManagerImpl
implements ILocalBreakpointResumeManager {
    private static final Logger log = LoggerFactory.getLogger(LocalBreakpointResumeManagerImpl.class);
    @Resource
    private UploadFilePathManager uploadFilePathManager;
    @Resource
    private LocalBreakpointResumeCallback uploadCallback;
    private static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final int BUF_SIZE = 24657920;
    public static long fileMaxByteSize = 0L;

    @Override
    public BreakpointRegisterDTO register(BreakpointRegister breakpointRegister) {
        File fileFolder;
        BreakpointRegisterDTO.BreakpointRegisterDTOBuilder resultBuilder = BreakpointRegisterDTO.builder();
        String fileCode = breakpointRegister.getFileCode();
        String fileExt = breakpointRegister.getFileExt();
        String fileName = breakpointRegister.getFileName();
        DataSize fileSize = breakpointRegister.getFileSize();
        String mergeFileFolderPath = this.uploadFilePathManager.getMergeFileFolderPath(fileCode);
        FileInfoOfFind fileInfoOfFind = this.uploadCallback.find(breakpointRegister);
        if (fileInfoOfFind != null && FileUploadStateEnum.UPLOADED.equals((Object)fileInfoOfFind.getState())) {
            resultBuilder.isUploaded(true).filePath(fileInfoOfFind.getFilePath()).fileId(String.valueOf(fileInfoOfFind.getId()));
            return resultBuilder.build();
        }
        if (fileInfoOfFind == null) {
            FileRegisterInfo registerInfo = FileRegisterInfo.builder().fileCode(fileCode).fileExt(fileExt).uploadStatus(FileUploadStateEnum.NOT_UPLOAD_COMPLETED).fileSize(fileSize).fileName(fileName).ext(breakpointRegister.getExt()).build();
            this.uploadCallback.save(registerInfo);
        }
        if (!(fileFolder = new File(mergeFileFolderPath)).exists()) {
            FileUtils.mkdirs((File)fileFolder);
        }
        return resultBuilder.isUploaded(false).build();
    }

    @Override
    public UploadChunkDTO uploadChunk(UploadChunk uploadChunk) {
        UploadChunkDTO result = UploadChunkDTO.builder().build();
        String chunkFileFolderPath = this.uploadFilePathManager.getChunkFileFolderPath(uploadChunk.getFileCode());
        File chunkFileFolder = new File(chunkFileFolderPath);
        FileUtils.mkdirs((File)chunkFileFolder);
        File chunkFile = new File(chunkFileFolderPath + uploadChunk.getChunk());
        try (InputStream inputStream = uploadChunk.getInputStream();
             FileOutputStream outputStream = new FileOutputStream(chunkFile);){
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public boolean checkChunk(String fileCode, Integer chunk, Integer chunkSize) {
        String chunkFileFolderPath = this.uploadFilePathManager.getChunkFileFolderPath(fileCode);
        File chunkFile = new File(chunkFileFolderPath + chunk);
        return chunkFile.exists() && chunkFile.length() == (long)chunkSize.intValue();
    }

    @Override
    public MergeChunksDTO mergeChunks(MergeChunks mergeChunks) throws Exception {
        mergeChunks.check();
        String fileExt = mergeChunks.getFileExt();
        String fileCode = mergeChunks.getFileCode();
        String fileName = mergeChunks.getFileName();
        String chunkFileFolderPath = this.uploadFilePathManager.getChunkFileFolderPath(fileCode);
        String mergeFilePath = this.uploadFilePathManager.getMergeFilePath(fileCode, fileExt);
        mergeChunks.setFilePath(mergeFilePath);
        mergeChunks.setChunkPath(chunkFileFolderPath);
        mergeChunks.setContentType(DEFAULT_CONTENT_TYPE);
        File chunkFileFolder = new File(chunkFileFolderPath);
        if (!chunkFileFolder.exists()) {
            throw new MergeChunksException("\u975e\u6cd5 fileCode \u503c");
        }
        File[] chunkFileArr = chunkFileFolder.listFiles();
        File mergeFile = new File(mergeFilePath);
        assert (chunkFileArr != null);
        List<File> chunkFileList = Arrays.stream(chunkFileArr).collect(Collectors.toList());
        boolean existFile = this.uploadCallback.exist(mergeChunks);
        if (!existFile) {
            log.error("\u5408\u5e76\u5931\u8d25\uff0c\u6ca1\u6709\u4ece\u6570\u636e\u5e93\u4e2d\u627e\u5230\u5bf9\u5e94\u4e0a\u4f20\u8bb0\u5f55");
            throw new MergeChunksException("\u5408\u5e76\u5931\u8d25, \u672a\u67e5\u627e\u5230\u4e0a\u4f20\u8bb0\u5f55");
        }
        this.sort(chunkFileList);
        int chunks = LocalBreakpointResumeManagerImpl.getChunks(chunkFileList);
        mergeChunks.setChunkFiles(chunkFileList);
        mergeChunks.setChunks(chunks);
        if (chunks <= 0) {
            throw new MergeChunksException("\u8bf7\u4e0a\u4f20\u5206\u7247");
        }
        boolean isMergeFile = this.uploadCallback.mergeBefore(mergeChunks);
        if (isMergeFile) {
            log.debug("\u5f00\u59cb\u5408\u5e76\u6587\u4ef6 => {}", (Object)fileName);
            this.mergeFile(chunkFileList, mergeFile);
        }
        MergeChunksDTO mergeChunksDTO = this.uploadCallback.mergeAfter(mergeChunks);
        FileUtil.del((String)chunkFileFolderPath);
        log.info("\u6587\u4ef6\u5408\u5e76\u5b8c\u6210 => {}", (Object)fileName);
        return mergeChunksDTO;
    }

    private void sort(List<File> fileList) {
        fileList.sort((o1, o2) -> {
            if (Integer.parseInt(o1.getName()) > Integer.parseInt(o2.getName())) {
                return 1;
            }
            return -1;
        });
    }

    private void mergeFile(List<File> chunkFileList, File mergeFile) {
        try {
            if (mergeFile.exists()) {
                mergeFile.delete();
            } else {
                mergeFile.createNewFile();
            }
            LocalBreakpointResumeManagerImpl.mergeFileWithNio(chunkFileList, mergeFile);
        }
        catch (Exception e) {
            log.error("error: ", (Throwable)e);
            throw new MergeChunksException("\u5408\u5e76\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
    }

    public static void mergeFileWithNio(List<File> files, File newFile) {
        AbstractInterruptibleChannel outChannel = null;
        AbstractInterruptibleChannel inChannel = null;
        int chunkCount = LocalBreakpointResumeManagerImpl.getChunks(files);
        try (FileOutputStream outputStream = new FileOutputStream(newFile);){
            outChannel = outputStream.getChannel();
            for (int i = 0; i < chunkCount; ++i) {
                File file = files.get(i);
                log.info("\u6b63\u5728\u5408\u5e76\u5206\u7247 [{}], \u5206\u7247\u5927\u5c0f: {}", (Object)file.getName(), (Object)file.length());
                try (FileInputStream inputStream = new FileInputStream(file);){
                    inChannel = inputStream.getChannel();
                    ByteBuffer bb = ByteBuffer.allocate(24657920);
                    while (((FileChannel)inChannel).read(bb) != -1) {
                        bb.flip();
                        ((FileChannel)outChannel).write(bb);
                        bb.clear();
                    }
                    inChannel.close();
                    continue;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            log.debug("\u6587\u4ef6\u5408\u5e76\u6210\u529f fileName: {}, fileSize: {}", (Object)newFile.getName(), (Object)newFile.length());
        }
        catch (IOException e) {
            log.error("error: ", (Throwable)e);
            throw new MergeChunksException("\u5408\u5e76\u5931\u8d25,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        finally {
            try {
                if (outChannel != null) {
                    outChannel.close();
                }
                if (inChannel != null) {
                    inChannel.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static int getChunks(List<File> files) {
        long fileTotalSize = 0L;
        int chunkCount = 0;
        for (File chunkFile : files) {
            if ((fileTotalSize += chunkFile.length()) > fileMaxByteSize) {
                log.warn("\u5ba2\u6237\u7aef\u5728\u6ce8\u518c\u6587\u4ef6\u65f6\u5019\uff0c\u6587\u4ef6\u5927\u5c0f\u8d85\u8fc7\u6700\u5927\u503c\uff0c\u6587\u4ef6\u4e0d\u4f1a\u88ab\u5408\u5e76\u4e14\u5206\u7247\u5c06\u4f1a\u88ab\u5220\u9664");
                chunkCount = 0;
                break;
            }
            ++chunkCount;
        }
        log.info("\u5206\u7247\u6570\u91cf\u4e3a [{}]", (Object)chunkCount);
        return chunkCount;
    }
}

