package cn.lingyangwl.framework.data.mate.fieldsensitive.model;

import cn.lingyangwl.framework.data.mate.annotations.FieldSensitive;
import cn.lingyangwl.framework.data.mate.fieldsensitive.inter.IFieldSensitiveAnnotationGetter;
import lombok.Getter;
import lombok.Setter;

import java.lang.reflect.Field;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

/**
 * @author shenguangyang
 */
@Getter
@Setter
public class SensitiveClassCache {
    private Class<?> clazz;
    /**
     * 添加了 {@link FieldSensitive} 注解或者是{@link IFieldSensitiveAnnotationGetter} 中指定的泛型注解
     * 的字段
     */
    private Set<FieldOfBaseType> fields;

    public SensitiveClassCache() {
        this.fields = new CopyOnWriteArraySet<>();
    }

    /**
     * 基本类型的字段数据, 这里的基本类型包含 String, 基本类型包装类, 基本类型非包装类
     */
    @Getter
    @Setter
    public static class FieldOfBaseType {
        private FieldSensitiveAnnotationData annoData;
        private Field field;
    }
}
