package cn.lingyangwl.framework.data.mate.fieldsensitive.enums;

import cn.lingyangwl.framework.data.mate.fieldsensitive.SensitiveDataUtils;
import lombok.Getter;

import java.util.function.Function;

/**
 * 枚举需要脱敏的字段类型
 *
 * @author shenguangyang
 */
@Getter
public enum StrategyType {
    /**
     * 置空
     */
    EMPTY((v) -> ""),
    DEFAULT((v) -> v),
    /**
     * 中文名
     */
    CHINESE_NAME(SensitiveDataUtils::chineseName),

    /**
     * 身份证号
     */
    ID_CARD(SensitiveDataUtils::idCardNum),
    /**
     * 座机号
     */
    FIXED_PHONE(SensitiveDataUtils::fixedPhone),
    /**
     * 手机号
     */
    MOBILE_PHONE(SensitiveDataUtils::mobilePhone),
    /**
     * 地址
     */
    ADDRESS((value) -> SensitiveDataUtils.setSensitiveSize(value, 4)),
    /**
     * 电子邮件
     */
    EMAIL(SensitiveDataUtils::email),
    /**
     * 银行卡
     */
    BANK_CARD(SensitiveDataUtils::bankCard),
    /**
     * 公司开户银行联号
     */
    BANK_NUMBER(SensitiveDataUtils::bankNumber),

    /**
     * 保留4位明文数据
     */
    RESERVE_4((v) -> SensitiveDataUtils.setReserveSize(v, 4)),
    RESERVE_6((v) -> SensitiveDataUtils.setReserveSize(v, 6)),
    RESERVE_8((v) -> SensitiveDataUtils.setReserveSize(v, 8)),
    ;

    private final Function<String, Object> dataProcessor;

    StrategyType(Function<String, Object> dataProcessor) {
        this.dataProcessor = dataProcessor;
    }
}
