package cn.lingyangwl.framework.data.mate.fieldsensitive;

import cn.lingyangwl.framework.data.mate.fieldsensitive.enums.StrategyType;
import cn.lingyangwl.framework.data.mate.fieldsensitive.inter.IFieldSensitiveAnnotationGetter;
import cn.lingyangwl.framework.data.mate.annotations.FieldSensitive;
import cn.lingyangwl.framework.data.mate.fieldsensitive.model.FieldSensitiveAnnotationData;
import org.springframework.stereotype.Component;

/**
 * @author shenguangyang
 */
@Component
public class DefaultFieldSensitiveAnnotationGetter implements IFieldSensitiveAnnotationGetter<FieldSensitive> {
    @Override
    public FieldSensitiveAnnotationData getData(FieldSensitive anno) {
        StrategyType strategy = anno.strategy();
        StrategyType value = anno.value();
        if (value != StrategyType.DEFAULT) {
            strategy = value;
        }
        return FieldSensitiveAnnotationData.builder().dataProcessor(strategy.getDataProcessor()).build();
    }
}
