package cn.lingyangwl.framework.data.mate.fieldbind.model;

import cn.lingyangwl.framework.data.mate.annotations.FieldBind;
import cn.lingyangwl.framework.data.mate.fieldbind.inter.IFieldBindAnnotationDataGetter;
import lombok.Getter;
import lombok.Setter;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 存放需要实体类中标注 {@link FieldBind} 注解的信息
 *
 * @author shenguangyang
 */
@Getter
@Setter
public class DictClassCache {
    private Class<?> clazz;
    /**
     * 添加了 {@link FieldBind} 注解或者是{@link IFieldBindAnnotationDataGetter} 中指定的泛型注解
     * 的字段
     */
    private List<FieldOfBaseType> fieldList;

    private Set<String> types;

    public DictClassCache() {
        this.fieldList = new ArrayList<>();
    }

    /**
     * 基本类型的字段数据, 这里的基本类型包含 String, 基本类型包装类, 基本类型非包装类
     */
    @Getter
    @Setter
    public static class FieldOfBaseType {
        private FieldBindAnnotationData annotationData;
        private Field field;
        private Field targetField;
    }

    public void fieldAnnotationTypes() {
        this.types = this.fieldList.stream().map(x -> x.getAnnotationData().getType()).collect(Collectors.toSet());
    }
}
