package cn.lingyangwl.framework.data.mate.exception;

import cn.lingyangwl.framework.tool.core.exception.BaseError;
import cn.lingyangwl.framework.tool.core.exception.BaseException;
import cn.hutool.core.util.StrUtil;

/**
 * @author shenguangyang
 */
public class FieldBindException extends BaseException {
    private static final long serialVersionUID = 1L;

    public FieldBindException(String message) {
        this.message = message;
    }

    public FieldBindException(CharSequence template, Object... params) {
        this.message = StrUtil.format(template, params);
    }

    public FieldBindException(BaseError baseError) {
        super(baseError);
    }

    public FieldBindException(Integer code, String message) {
        this.message = message;
        this.code = code;
    }

    @Override
    public String getMessage() {
        return message;
    }

    public Integer getCode() {
        return code;
    }
}