package cn.lingyangwl.framework.data.mate.annotations;

import cn.lingyangwl.framework.data.mate.fieldsensitive.enums.StrategyType;

import java.lang.annotation.*;

/**
 * 数据脱敏
 *
 * @author shenguangyang
 */
@Target({ElementType.FIELD, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
@Inherited
@Documented
public @interface FieldSensitive {
    /**
     * 等同于 {@link #strategy()}
     */
    StrategyType value() default StrategyType.DEFAULT;

    /**
     * 策略
     */
    StrategyType strategy() default StrategyType.DEFAULT;
}
