package cn.lingyangwl.framework.data.mate.annotations;

import java.lang.annotation.*;

/**
 * 字段绑定 (回写字典), 在对象属性上使用
 *
 * @author shenguangyang
 */
@Documented
@Inherited
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.FIELD, ElementType.ANNOTATION_TYPE})
public @interface FieldBind {
    String sharding() default "";

    /**
     * 分隔每个元素的分隔符号(字典字段分隔符)
     * <p>
     * 当前注解所在字符串字段code时候, 每个code采用什么分割这里要指明 <br/>
     * eg:
     * <blockquote><pre>
     * {@literal @FieldBind(type = "test", target = "testText", delimiter = "|")}
     *  private String test;
     *  private String testText;
     * </pre></blockquote>
     * 当 test = 1|2|3(假如code = 1 对应 data1, 依次类推), 则testText将被赋值为
     * testText = data1|data2|data3<br/>
     * 目标字段分隔符, 请看 {@link #targetDelimiter()}
     * </p>
     *
     * @apiNote 只有在字段类型是 {@code String} 时才会生效
     */
    String delimiter() default "";

    /**
     * 目标字段分隔符
     */
    String targetDelimiter() default "";

    /**
     * 字典划分成如下几部分
     * <p>
     * type: 类型, 一组键值对是属于啥类型的 <br/>
     * code: 类型中每个元素的key就是code编码 <br/>
     * value: code对应的值 <br/>
     * </p>
     */
    String type();

    /**
     * 目标字段名
     */
    String target();
}

