package cn.lingyangwl.framework.data.mate;

import cn.lingyangwl.framework.data.mate.fieldbind.DefaultDataBind;
import cn.lingyangwl.framework.data.mate.fieldbind.DefaultFieldBindAnnotationGetter;
import cn.lingyangwl.framework.data.mate.fieldbind.FieldBindHandler;
import cn.lingyangwl.framework.data.mate.fieldbind.aspect.FieldBindSetterAspect;
import cn.lingyangwl.framework.data.mate.fieldbind.inter.IDataBind;
import cn.lingyangwl.framework.data.mate.fieldsensitive.DefaultFieldSensitiveAnnotationGetter;
import cn.lingyangwl.framework.data.mate.fieldsensitive.FieldSensitiveHandler;
import cn.lingyangwl.framework.data.mate.fieldsensitive.aspect.FieldSensitiveHandleAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

import javax.annotation.PostConstruct;

/**
 * @author shenguangyang
 */
@AutoConfiguration
@Import({
        FieldBindHandler.class, FieldBindSetterAspect.class, DefaultFieldBindAnnotationGetter.class,
        FieldSensitiveHandler.class, DefaultFieldSensitiveAnnotationGetter.class, FieldSensitiveHandleAspect.class
})
public class LyDataMateAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(LyDataMateAutoConfiguration.class);

    @PostConstruct
    public void init() {
        log.info("init {}", this.getClass().getName());
    }

    @Bean
    @ConditionalOnMissingBean(IDataBind.class)
    public DefaultDataBind defaultDataBind() {
        return new DefaultDataBind();
    }
}
