/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.poi.excel;

import cn.hutool.core.util.StrUtil;
import java.util.Arrays;

public enum ExcelType {
    XLS("xls", "application/vnd.ms-excel"),
    XLSX("xlsx", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");

    private final String name;
    private final String contentType;

    public static ExcelType ofByName(String name) {
        return Arrays.stream(ExcelType.values()).filter(e -> StrUtil.equalsIgnoreCase((CharSequence)e.name, (CharSequence)name)).findFirst().orElse(null);
    }

    public static ExcelType ofByContentType(String contentType) {
        return Arrays.stream(ExcelType.values()).filter(e -> StrUtil.equalsIgnoreCase((CharSequence)e.contentType, (CharSequence)contentType)).findFirst().orElse(null);
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    private ExcelType(String name, String contentType) {
        this.name = name;
        this.contentType = contentType;
    }
}

