package cn.lingyangwl.framework.tool.crypto.asymmetric;

import cn.lingyangwl.framework.tool.core.Base64Utils;
import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;

import java.util.Base64;

/**
 * @author shenguangyang
 */
public class RsaAsymmetricCrypto extends BaseAsymmetricCrypto {

    public RsaAsymmetricCrypto() {

    }

    @Override
    public byte[] decrypt(String data, KeyType keyType, String privateKey, String publicKey) {
        RSA rsa = new RSA(privateKey, publicKey);
        return rsa.decrypt(data, keyType);
    }

    @Override
    public String encrypt(String data, KeyType keyType, String privateKey, String publicKey) {
        RSA rsa = new RSA(privateKey, publicKey);
        return Base64Utils.encode(rsa.encrypt(data, keyType));
    }

    @Override
    public CryptoKeyResp getKey() {
        RSA rsa = new RSA();
        return CryptoKeyResp.builder()
                .privateKey(Base64.getEncoder().encodeToString(rsa.getPrivateKey().getEncoded()))
                .publicKey(Base64.getEncoder().encodeToString(rsa.getPublicKey().getEncoded()))
                .build();
    }

    @Override
    public AsymmetricCryptoType type() {
        return AsymmetricCryptoType.RSA;
    }
}
