/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.tool.crypto.asymmetric;

import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.RSA;
import cn.lingyangwl.framework.tool.core.Base64Utils;
import cn.lingyangwl.framework.tool.crypto.asymmetric.AsymmetricCryptoType;
import cn.lingyangwl.framework.tool.crypto.asymmetric.BaseAsymmetricCrypto;
import cn.lingyangwl.framework.tool.crypto.asymmetric.CryptoKeyResp;
import java.util.Base64;

public class RsaAsymmetricCrypto
extends BaseAsymmetricCrypto {
    @Override
    public byte[] decrypt(String data, KeyType keyType, String privateKey, String publicKey) {
        RSA rsa = new RSA(privateKey, publicKey);
        return rsa.decrypt(data, keyType);
    }

    @Override
    public String encrypt(String data, KeyType keyType, String privateKey, String publicKey) {
        RSA rsa = new RSA(privateKey, publicKey);
        return Base64Utils.encode((byte[])rsa.encrypt(data, keyType));
    }

    @Override
    public CryptoKeyResp getKey() {
        RSA rsa = new RSA();
        return CryptoKeyResp.builder().privateKey(Base64.getEncoder().encodeToString(rsa.getPrivateKey().getEncoded())).publicKey(Base64.getEncoder().encodeToString(rsa.getPublicKey().getEncoded())).build();
    }

    @Override
    public AsymmetricCryptoType type() {
        return AsymmetricCryptoType.RSA;
    }
}

