/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.tool.crypto;

import cn.hutool.crypto.Mode;
import cn.hutool.crypto.Padding;
import cn.hutool.crypto.symmetric.AES;
import cn.lingyangwl.framework.tool.core.StringUtils;
import cn.lingyangwl.framework.tool.core.exception.Assert;
import cn.lingyangwl.framework.tool.core.exception.UtilException;
import java.nio.charset.StandardCharsets;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class AesCrypto {
    private static final String IV_KEY = "bXPK6s6lCMnB1JLW";
    private final AES aes;

    public AesCrypto(String secretKey, Mode mode, Padding padding) {
        Assert.notNull((Object)mode, (String)"aes mode is null");
        Assert.notNull((Object)padding, (String)"aes padding is null");
        this.aes = AesCrypto.getAes(secretKey, mode, padding);
    }

    public AesCrypto(String secretKey) {
        this.aes = AesCrypto.getAes(secretKey);
    }

    public static void checkSecretKey(String secretKey) {
        if (StringUtils.isEmpty((String)secretKey)) {
            throw new UtilException("\u975e\u6cd5\u5bc6\u94a5");
        }
        if (secretKey.length() != 16 && secretKey.length() != 32) {
            throw new UtilException("secretKey length only is 16 or 32");
        }
    }

    public String decrypt(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return data;
        }
        byte[] decryptDataBase64 = this.aes.decrypt(data);
        return new String(decryptDataBase64, StandardCharsets.UTF_8);
    }

    public String encrypt(String data) {
        if (StringUtils.isEmpty((String)data)) {
            return data;
        }
        return this.aes.encryptBase64(data, StandardCharsets.UTF_8);
    }

    private static AES getAes(String secretKey, Mode mode, Padding padding) {
        AesCrypto.checkSecretKey(secretKey);
        AES aes = Mode.CBC == mode ? new AES(mode, padding, (SecretKey)new SecretKeySpec(secretKey.getBytes(), "AES"), (AlgorithmParameterSpec)new IvParameterSpec(IV_KEY.getBytes())) : new AES(mode, padding, (SecretKey)new SecretKeySpec(secretKey.getBytes(), "AES"));
        return aes;
    }

    private static AES getAes(String secretKey) {
        return AesCrypto.getAes(secretKey, Mode.CBC, Padding.ZeroPadding);
    }
}

