package cn.lingyangwl.framework.tool.crypto.asymmetric;

import cn.hutool.crypto.asymmetric.KeyType;
import lombok.Getter;
import lombok.Setter;

/**
 * @author shenguangyang
 */
@Getter
@Setter
public abstract class BaseAsymmetricCrypto {

    public abstract byte[] decrypt(String data, KeyType keyType, String privateKey, String publicKey);
    public abstract String encrypt(String data, KeyType keyType, String privateKey, String publicKey);

    /**
     * 获取公钥和私钥
     */
    public abstract CryptoKeyResp getKey();

    public abstract AsymmetricCryptoType type();
}
