/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.cache.redis.utils;

import cn.lingyangwl.framework.cache.core.key.ICacheKey;
import cn.lingyangwl.framework.core.utils.spring.SpringUtils;
import com.alibaba.fastjson2.JSON;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisUtils
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(RedisUtils.class);
    private static RedisTemplate redisTemplate;
    private static StringRedisTemplate stringRedisTemplate;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        redisTemplate = (RedisTemplate)applicationContext.getBean("redisTemplate");
        stringRedisTemplate = (StringRedisTemplate)applicationContext.getBean(StringRedisTemplate.class);
    }

    private static RedisTemplate getRedisTemplate() {
        return Optional.ofNullable(redisTemplate).orElse((RedisTemplate)SpringUtils.getBean((String)"redisTemplate"));
    }

    public static class Helper {
        public static final String DEFAULT_SYMBOL = ":";

        public static String join(String ... args) {
            return Helper.joinBySymbol(DEFAULT_SYMBOL, args);
        }

        public static String joinBySymbol(String symbol, String ... args) {
            if (symbol == null || symbol.trim().length() == 0) {
                throw new RuntimeException(" symbol must not be empty!");
            }
            if (args == null || args.length == 0) {
                throw new RuntimeException(" args must not be empty!");
            }
            StringBuilder sb = new StringBuilder(16);
            for (String arg : args) {
                sb.append(arg).append(symbol);
            }
            sb.replace(sb.length() - symbol.length(), sb.length(), "");
            return sb.toString();
        }
    }

    public static class RedisOpsResultIsNullException
    extends NullPointerException {
        public RedisOpsResultIsNullException() {
        }

        public RedisOpsResultIsNullException(String message) {
            super(message);
        }
    }

    public static class ZSetOps {
        public static boolean zAdd(String key, String item, double score) {
            Boolean result = RedisUtils.getRedisTemplate().opsForZSet().add((Object)key, (Object)item, score);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static long zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> entries) {
            Long count = RedisUtils.getRedisTemplate().opsForZSet().add((Object)key, entries);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static long zRemove(String key, Object ... items) {
            Long count = RedisUtils.getRedisTemplate().opsForZSet().remove((Object)key, items);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static long zRemoveRange(String key, long startRange, long endRange) {
            Long count = RedisUtils.getRedisTemplate().opsForZSet().removeRange((Object)key, startRange, endRange);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static long zRemoveRangeByScore(String key, double minScore, double maxScore) {
            Long count = RedisUtils.getRedisTemplate().opsForZSet().removeRangeByScore((Object)key, minScore, maxScore);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static double zIncrementScore(String key, String item, double delta) {
            Double scoreValue = RedisUtils.getRedisTemplate().opsForZSet().incrementScore((Object)key, (Object)item, delta);
            if (scoreValue == null) {
                throw new RedisOpsResultIsNullException();
            }
            return scoreValue;
        }

        public static long zRank(String key, Object item) {
            Long rank = RedisUtils.getRedisTemplate().opsForZSet().rank((Object)key, item);
            if (rank == null) {
                throw new RedisOpsResultIsNullException();
            }
            return rank;
        }

        public static long zReverseRank(String key, Object item) {
            Long reverseRank = RedisUtils.getRedisTemplate().opsForZSet().reverseRank((Object)key, item);
            if (reverseRank == null) {
                throw new RedisOpsResultIsNullException();
            }
            return reverseRank;
        }

        public static Set<Object> zRange(String key, long start, long end) {
            return RedisUtils.getRedisTemplate().opsForZSet().range((Object)key, start, end);
        }

        public static Set<Object> zWholeZSetItem(String key) {
            return RedisUtils.getRedisTemplate().opsForZSet().range((Object)key, 0L, -1L);
        }

        public static Set<ZSetOperations.TypedTuple<Object>> zRangeWithScores(String key, long start, long end) {
            return RedisUtils.getRedisTemplate().opsForZSet().rangeWithScores((Object)key, start, end);
        }

        public static Set<ZSetOperations.TypedTuple<Object>> zWholeZSetEntry(String key) {
            return RedisUtils.getRedisTemplate().opsForZSet().rangeWithScores((Object)key, 0L, -1L);
        }

        public static Set<Object> zRangeByScore(String key, double minScore, double maxScore) {
            return RedisUtils.getRedisTemplate().opsForZSet().rangeByScore((Object)key, minScore, maxScore);
        }

        public static Set<Object> zRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
            return RedisUtils.getRedisTemplate().opsForZSet().rangeByScore((Object)key, minScore, maxScore, offset, count);
        }

        public static Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double minScore, double maxScore) {
            return RedisUtils.getRedisTemplate().opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore);
        }

        public static Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double minScore, double maxScore, long offset, long count) {
            return RedisUtils.getRedisTemplate().opsForZSet().rangeByScoreWithScores((Object)key, minScore, maxScore, offset, count);
        }

        public static Set<Object> zReverseRange(String key, long start, long end) {
            return RedisUtils.getRedisTemplate().opsForZSet().reverseRange((Object)key, start, end);
        }

        public static Set<ZSetOperations.TypedTuple<Object>> zReverseRangeWithScores(String key, long start, long end) {
            log.info("zReverseRangeWithScores(...) => key -> {}, start -> {}, end -> {}", new Object[]{key, start, end});
            Set entries = RedisUtils.getRedisTemplate().opsForZSet().reverseRangeWithScores((Object)key, start, end);
            log.info("zReverseRangeWithScores(...) => entries -> {}", (Object)JSON.toJSONString((Object)entries));
            return entries;
        }

        public static Set<Object> zReverseRangeByScore(String key, double minScore, double maxScore) {
            return RedisUtils.getRedisTemplate().opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore);
        }

        public static Set<ZSetOperations.TypedTuple<Object>> zReverseRangeByScoreWithScores(String key, double minScore, double maxScore) {
            return RedisUtils.getRedisTemplate().opsForZSet().reverseRangeByScoreWithScores((Object)key, minScore, maxScore);
        }

        public static Set<Object> zReverseRangeByScore(String key, double minScore, double maxScore, long offset, long count) {
            return RedisUtils.getRedisTemplate().opsForZSet().reverseRangeByScore((Object)key, minScore, maxScore, offset, count);
        }

        public static long zCount(String key, double minScore, double maxScore) {
            Long count = RedisUtils.getRedisTemplate().opsForZSet().count((Object)key, minScore, maxScore);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static long zSize(String key) {
            Long size = RedisUtils.getRedisTemplate().opsForZSet().size((Object)key);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long zZCard(String key) {
            Long size = RedisUtils.getRedisTemplate().opsForZSet().zCard((Object)key);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static double zScore(String key, Object item) {
            Double score = RedisUtils.getRedisTemplate().opsForZSet().score((Object)key, item);
            if (score == null) {
                throw new RedisOpsResultIsNullException();
            }
            return score;
        }

        public static long zUnionAndStore(String key, String otherKey, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long zUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForZSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long zIntersectAndStore(String key, String otherKey, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long zIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }
    }

    public static class SetOps {
        public static long sAdd(String key, Object ... items) {
            Long count = RedisUtils.getRedisTemplate().opsForSet().add((Object)key, items);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static long sRemove(String key, Object ... items) {
            Long count = RedisUtils.getRedisTemplate().opsForSet().remove((Object)key, items);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static Object sPop(String key) {
            return RedisUtils.getRedisTemplate().opsForSet().pop((Object)key);
        }

        public static boolean sMove(String sourceKey, String item, String destinationKey) {
            Boolean result = RedisUtils.getRedisTemplate().opsForSet().move((Object)sourceKey, (Object)item, (Object)destinationKey);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static long sSize(String key) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().size((Object)key);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static boolean sIsMember(String key, Object item) {
            Boolean result = RedisUtils.getRedisTemplate().opsForSet().isMember((Object)key, item);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static Set<Object> sIntersect(String key, String otherKey) {
            return RedisUtils.getRedisTemplate().opsForSet().intersect((Object)key, (Object)otherKey);
        }

        public static Set<Object> sIntersect(String key, Collection<String> otherKeys) {
            return RedisUtils.getRedisTemplate().opsForSet().intersect((Object)key, otherKeys);
        }

        public static long sIntersectAndStore(String key, String otherKey, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long sIntersectAndStore(String key, Collection<String> otherKeys, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().intersectAndStore((Object)key, otherKeys, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static Set<Object> sUnion(String key, String otherKey) {
            return RedisUtils.getRedisTemplate().opsForSet().union((Object)key, (Object)otherKey);
        }

        public static Set<Object> sUnion(String key, Collection<String> otherKeys) {
            return RedisUtils.getRedisTemplate().opsForSet().union((Object)key, otherKeys);
        }

        public static long sUnionAndStore(String key, String otherKey, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long sUnionAndStore(String key, Collection<String> otherKeys, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().unionAndStore((Object)key, otherKeys, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static Set<Object> sDifference(String key, String otherKey) {
            return RedisUtils.getRedisTemplate().opsForSet().difference((Object)key, (Object)otherKey);
        }

        public static Set<Object> sDifference(String key, Collection<String> otherKeys) {
            return RedisUtils.getRedisTemplate().opsForSet().difference((Object)key, otherKeys);
        }

        public static long sDifferenceAndStore(String key, String otherKey, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long sDifferenceAndStore(String key, Collection<String> otherKeys, String storeKey) {
            Long size = RedisUtils.getRedisTemplate().opsForSet().differenceAndStore((Object)key, otherKeys, (Object)storeKey);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static Set<Object> sMembers(String key) {
            return RedisUtils.getRedisTemplate().opsForSet().members((Object)key);
        }

        public static Object sRandomMember(String key) {
            return RedisUtils.getRedisTemplate().opsForSet().randomMember((Object)key);
        }

        public static List<Object> sRandomMembers(String key, long count) {
            return RedisUtils.getRedisTemplate().opsForSet().randomMembers((Object)key, count);
        }

        public static Set<Object> sDistinctRandomMembers(String key, long count) {
            return RedisUtils.getRedisTemplate().opsForSet().distinctRandomMembers((Object)key, count);
        }

        public static Cursor<Object> sScan(String key, ScanOptions options) {
            return RedisUtils.getRedisTemplate().opsForSet().scan((Object)key, options);
        }
    }

    public static class ListOps {
        public static long lLeftPush(String key, Object item) {
            Long size = RedisUtils.getRedisTemplate().opsForList().leftPush((Object)key, item);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lLeftPushAll(String key, Object ... items) {
            Long size = RedisUtils.getRedisTemplate().opsForList().leftPushAll((Object)key, items);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lLeftPushAll(String key, Collection<Object> items) {
            Long size = RedisUtils.getRedisTemplate().opsForList().leftPushAll((Object)key, items);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lLeftPushIfPresent(String key, Object item) {
            Long size = RedisUtils.getRedisTemplate().opsForList().leftPushIfPresent((Object)key, item);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lLeftPush(String key, String pivot, Object item) {
            Long size = RedisUtils.getRedisTemplate().opsForList().leftPush((Object)key, (Object)pivot, item);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lRightPush(String key, Object item) {
            Long size = RedisUtils.getRedisTemplate().opsForList().rightPush((Object)key, item);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lRightPushAll(String key, Object ... items) {
            Long size = RedisUtils.getRedisTemplate().opsForList().rightPushAll((Object)key, items);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lRightPushAll(String key, Collection<String> items) {
            Long size = RedisUtils.getRedisTemplate().opsForList().rightPushAll((Object)key, items);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lRightPushIfPresent(String key, Object item) {
            Long size = RedisUtils.getRedisTemplate().opsForList().rightPushIfPresent((Object)key, item);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lRightPush(String key, String pivot, Object item) {
            Long size = RedisUtils.getRedisTemplate().opsForList().rightPush((Object)key, (Object)pivot, item);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static <T> T lLeftPop(String key) {
            ListOperations operations = RedisUtils.getRedisTemplate().opsForList();
            return (T)operations.leftPop((Object)key);
        }

        public static <T> T lLeftPop(String key, long timeout, TimeUnit unit) {
            ListOperations operations = RedisUtils.getRedisTemplate().opsForList();
            return (T)operations.leftPop((Object)key, timeout, unit);
        }

        public static <T> T lRightPop(String key) {
            ListOperations operations = RedisUtils.getRedisTemplate().opsForList();
            return (T)operations.rightPop((Object)key);
        }

        public static <T> T lRightPop(String key, long timeout, TimeUnit unit) {
            ListOperations operations = RedisUtils.getRedisTemplate().opsForList();
            return (T)operations.rightPop((Object)key, timeout, unit);
        }

        public static <T> T lRightPopAndLeftPush(String sourceKey, String destinationKey) {
            ListOperations operations = RedisUtils.getRedisTemplate().opsForList();
            return (T)operations.rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
        }

        public static Object lRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
            return RedisUtils.getRedisTemplate().opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
        }

        public static void lSet(String key, long index, String item) {
            RedisUtils.getRedisTemplate().opsForList().set((Object)key, index, (Object)item);
        }

        public static Object lIndex(String key, long index) {
            return RedisUtils.getRedisTemplate().opsForList().index((Object)key, index);
        }

        public static List<Object> lRange(String key, long start, long end) {
            return RedisUtils.getRedisTemplate().opsForList().range((Object)key, start, end);
        }

        public static List<Object> lWholeList(String key) {
            return RedisUtils.getRedisTemplate().opsForList().range((Object)key, 0L, -1L);
        }

        public static long lSize(String key) {
            Long size = RedisUtils.getRedisTemplate().opsForList().size((Object)key);
            if (size == null) {
                throw new RedisOpsResultIsNullException();
            }
            return size;
        }

        public static long lRemove(String key, long expectCount, String item) {
            Long actualCount = RedisUtils.getRedisTemplate().opsForList().remove((Object)key, expectCount, (Object)item);
            if (actualCount == null) {
                throw new RedisOpsResultIsNullException();
            }
            return actualCount;
        }

        public static void lTrim(String key, long start, long end) {
            RedisUtils.getRedisTemplate().opsForList().trim((Object)key, start, end);
        }
    }

    public static class HashOps {
        public static void hPut(String key, String entryKey, Object entryValue) {
            RedisUtils.getRedisTemplate().opsForHash().put((Object)key, (Object)entryKey, entryValue);
        }

        public static void hPutAll(String key, Map<Object, Object> maps) {
            RedisUtils.getRedisTemplate().opsForHash().putAll((Object)key, maps);
        }

        public static boolean hPutIfAbsent(String key, Object entryKey, Object entryValue) {
            return RedisUtils.getRedisTemplate().opsForHash().putIfAbsent((Object)key, entryKey, entryValue);
        }

        public static Object hGet(String key, Object entryKey) {
            log.info("hGet(...) => key -> {}, entryKey -> {}", (Object)key, entryKey);
            Object entryValue = RedisUtils.getRedisTemplate().opsForHash().get((Object)key, entryKey);
            log.info("hGet(...) => entryValue -> {}", entryValue);
            return entryValue;
        }

        public static Map<String, Object> hGetAll(String key) {
            return RedisUtils.getRedisTemplate().opsForHash().entries((Object)key);
        }

        public static List<Object> hMultiGet(String key, Collection<Object> entryKeys) {
            return RedisUtils.getRedisTemplate().opsForHash().multiGet((Object)key, entryKeys);
        }

        public static long hDelete(String key, Object ... entryKeys) {
            return RedisUtils.getRedisTemplate().opsForHash().delete((Object)key, entryKeys);
        }

        public static boolean hExists(String key, String entryKey) {
            return RedisUtils.getRedisTemplate().opsForHash().hasKey((Object)key, (Object)entryKey);
        }

        public static long hIncrBy(String key, Object entryKey, long increment) {
            return RedisUtils.getRedisTemplate().opsForHash().increment((Object)key, entryKey, increment);
        }

        public static double hIncrByFloat(String key, Object entryKey, double increment) {
            return RedisUtils.getRedisTemplate().opsForHash().increment((Object)key, entryKey, increment);
        }

        public static Set<Object> hKeys(String key) {
            return RedisUtils.getRedisTemplate().opsForHash().keys((Object)key);
        }

        public static List<Object> hValues(String key) {
            return RedisUtils.getRedisTemplate().opsForHash().values((Object)key);
        }

        public static long hSize(String key) {
            return RedisUtils.getRedisTemplate().opsForHash().size((Object)key);
        }

        public static Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
            Cursor cursor = RedisUtils.getRedisTemplate().opsForHash().scan((Object)key, options);
            return cursor;
        }
    }

    public static class StringOps {
        public static void set(String key, Object value) {
            RedisUtils.getRedisTemplate().opsForValue().set((Object)key, value);
        }

        public static boolean setBit(String key, long offset, boolean value) {
            Boolean result = RedisUtils.getRedisTemplate().opsForValue().setBit((Object)key, offset, value);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static void setEx(String key, Object value, long timeout, TimeUnit unit) {
            RedisUtils.getRedisTemplate().opsForValue().set((Object)key, value, timeout, unit);
        }

        public static void setEx(String key, Object value, long timeout) {
            RedisUtils.getRedisTemplate().opsForValue().set((Object)key, value, timeout, TimeUnit.SECONDS);
        }

        public static boolean setIfAbsent(String key, String value) {
            Boolean result = RedisUtils.getRedisTemplate().opsForValue().setIfAbsent((Object)key, (Object)value);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static boolean setIfAbsent(String key, String value, long timeout, TimeUnit unit) {
            Boolean result = RedisUtils.getRedisTemplate().opsForValue().setIfAbsent((Object)key, (Object)value, timeout, unit);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static void setRange(String key, String replaceValue, long offset) {
            RedisUtils.getRedisTemplate().opsForValue().set((Object)key, (Object)replaceValue, offset);
        }

        public static long size(String key) {
            Long result = RedisUtils.getRedisTemplate().opsForValue().size((Object)key);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static void multiSet(Map<String, Object> maps) {
            RedisUtils.getRedisTemplate().opsForValue().multiSet(maps);
        }

        public static boolean multiSetIfAbsent(Map<String, Object> maps) {
            Boolean result = RedisUtils.getRedisTemplate().opsForValue().multiSetIfAbsent(maps);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static long incrBy(String key, long increment) {
            Long result = RedisUtils.getRedisTemplate().opsForValue().increment((Object)key, increment);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static double incrByFloat(String key, double increment) {
            Double result = RedisUtils.getRedisTemplate().opsForValue().increment((Object)key, increment);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static int append(String key, String value) {
            Integer result = RedisUtils.getRedisTemplate().opsForValue().append((Object)key, value);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static Object get(String key) {
            return RedisUtils.getRedisTemplate().opsForValue().get((Object)key);
        }

        public static Object get(ICacheKey cacheKey) {
            return StringOps.get(cacheKey.getKey());
        }

        public static String getRange(String key, long start, long end) {
            return RedisUtils.getRedisTemplate().opsForValue().get((Object)key, start, end);
        }

        public static Object getAndSet(String key, Object newValue) {
            return RedisUtils.getRedisTemplate().opsForValue().getAndSet((Object)key, newValue);
        }

        public static boolean getBit(String key, long offset) {
            Boolean result = RedisUtils.getRedisTemplate().opsForValue().getBit((Object)key, offset);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static List<Object> multiGet(Collection<String> keys) {
            return RedisUtils.getRedisTemplate().opsForValue().multiGet(keys);
        }
    }

    public static class KeyOps {
        public static boolean delete(String key) {
            Boolean result = RedisUtils.getRedisTemplate().delete((Object)key);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static long delete(Collection<String> keys) {
            Long count = RedisUtils.getRedisTemplate().delete(keys);
            if (count == null) {
                throw new RedisOpsResultIsNullException();
            }
            return count;
        }

        public static byte[] dump(String key) {
            return RedisUtils.getRedisTemplate().dump((Object)key);
        }

        public static void restore(String key, byte[] value, long timeToLive, TimeUnit unit) {
            KeyOps.restore(key, value, timeToLive, unit, false);
        }

        public static void restore(String key, byte[] value, long timeout, TimeUnit unit, boolean replace) {
            log.info("restore(...) => key -> {}, value -> {}, timeout -> {}, unit -> {}, replace -> {}", new Object[]{key, value, timeout, unit, replace});
            RedisUtils.getRedisTemplate().restore((Object)key, value, timeout, unit, replace);
        }

        public static boolean hasKey(String key) {
            Boolean result = RedisUtils.getRedisTemplate().hasKey((Object)key);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static boolean expire(String key, long timeout, TimeUnit unit) {
            Boolean result = RedisUtils.getRedisTemplate().expire((Object)key, timeout, unit);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static boolean expireAt(String key, Date date) {
            Boolean result = RedisUtils.getRedisTemplate().expireAt((Object)key, date);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static Set<String> keys(String pattern) {
            return RedisUtils.getRedisTemplate().keys((Object)pattern);
        }

        public static boolean move(String key, int dbIndex) {
            Boolean result = RedisUtils.getRedisTemplate().move((Object)key, dbIndex);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static boolean persist(String key) {
            Boolean result = RedisUtils.getRedisTemplate().persist((Object)key);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static long getExpire(String key) {
            return KeyOps.getExpire(key, TimeUnit.SECONDS);
        }

        public static long getExpire(String key, TimeUnit unit) {
            Long result = RedisUtils.getRedisTemplate().getExpire((Object)key, unit);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static Object randomKey() {
            return RedisUtils.getRedisTemplate().randomKey();
        }

        public static void rename(String oldKey, String newKey) {
            RedisUtils.getRedisTemplate().rename((Object)oldKey, (Object)newKey);
        }

        public static boolean renameIfAbsent(String oldKey, String newKey) {
            Boolean result = RedisUtils.getRedisTemplate().renameIfAbsent((Object)oldKey, (Object)newKey);
            if (result == null) {
                throw new RedisOpsResultIsNullException();
            }
            return result;
        }

        public static DataType type(String key) {
            return RedisUtils.getRedisTemplate().type((Object)key);
        }
    }

    public static class DbOps {
        public <T> T find(String key, long timeout, Supplier<T> findFromDb) {
            Object cacheObject = StringOps.get(key);
            if (cacheObject != null) {
                return (T)cacheObject;
            }
            T dbObj = findFromDb.get();
            if (dbObj == null) {
                return null;
            }
            if (dbObj instanceof List && ((List)dbObj).size() == 0) {
                return null;
            }
            StringOps.setEx(key, dbObj, timeout, TimeUnit.SECONDS);
            return dbObj;
        }

        public <T> T update(String key, Supplier<Integer> updateFromDb) {
            Integer integer = updateFromDb.get();
            if (integer == 0) {
                return null;
            }
            KeyOps.delete(key);
            return (T)integer;
        }

        public <T> T delete(String key, Supplier<Integer> deleteFromDb) {
            return this.update(key, deleteFromDb);
        }
    }
}

