/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.cache.redis.service;

import cn.lingyangwl.framework.cache.core.key.ICacheKey;
import cn.lingyangwl.framework.cache.core.service.CacheService;
import cn.lingyangwl.framework.cache.core.service.HashOps;
import cn.lingyangwl.framework.cache.core.service.KeyOps;
import cn.lingyangwl.framework.cache.core.service.ListOps;
import cn.lingyangwl.framework.cache.core.service.ValueOps;
import cn.lingyangwl.framework.cache.redis.service.RedisHashOps;
import cn.lingyangwl.framework.cache.redis.service.RedisKeyOps;
import cn.lingyangwl.framework.cache.redis.service.RedisListOps;
import cn.lingyangwl.framework.cache.redis.service.RedisValueOps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.stereotype.Component;

@Component
public class RedisService
implements CacheService {
    @Resource
    public RedisTemplate redisTemplate;
    @Resource
    private RedisKeyOps keyOps;
    @Resource
    private RedisHashOps hashOps;
    @Resource
    private RedisValueOps valueOps;
    @Resource
    private RedisListOps listOps;

    @Override
    public KeyOps opsForKey() {
        return this.keyOps;
    }

    @Override
    public ListOps opsForList() {
        return this.listOps;
    }

    @Override
    public ValueOps opsForValue() {
        return this.valueOps;
    }

    @Override
    public HashOps opsForHash() {
        return this.hashOps;
    }

    public <T> void setCacheObject(String key, T value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public <T> void setCacheObject(ICacheKey key, T value, Object ... keyParams) {
        this.redisTemplate.opsForValue().set((Object)key.formatKey(keyParams), value);
    }

    public <T> void setCacheObject(String key, T value, Long timeout, TimeUnit timeUnit) {
        this.redisTemplate.opsForValue().set((Object)key, value, timeout.longValue(), timeUnit);
    }

    public Long decrement(ICacheKey key, String keyParams) {
        return this.redisTemplate.opsForValue().decrement((Object)key.formatKey(keyParams));
    }

    public boolean expire(String key, long timeout) {
        return this.expire(key, timeout, TimeUnit.SECONDS);
    }

    public boolean expire(ICacheKey key, Object ... keyParams) {
        return this.expire(key.formatKey(keyParams), key.getExpire(), key.getUnit());
    }

    public boolean expire(String key, long timeout, TimeUnit unit) {
        return Boolean.TRUE.equals(this.redisTemplate.expire((Object)key, timeout, unit));
    }

    public <T> T getCacheObject(String key) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key);
    }

    public <T> T getCacheObject(ICacheKey key, Object ... keyParams) {
        ValueOperations operation = this.redisTemplate.opsForValue();
        return (T)operation.get((Object)key.formatKey(keyParams));
    }

    public boolean deleteObject(String key) {
        return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key));
    }

    public boolean deleteObject(ICacheKey key, Object ... keyParams) {
        return Boolean.TRUE.equals(this.redisTemplate.delete((Object)key.formatKey(keyParams)));
    }

    public long deleteObject(Collection collection) {
        return this.redisTemplate.delete(collection);
    }

    public <T> long setCacheList(String key, List<T> dataList) {
        Long count = this.redisTemplate.opsForList().rightPushAll((Object)key, dataList);
        return count == null ? 0L : count;
    }

    public <T> List<T> getCacheList(String key) {
        return this.redisTemplate.opsForList().range((Object)key, 0L, -1L);
    }

    public <T> BoundSetOperations<String, T> setCacheSet(String key, Set<T> dataSet) {
        BoundSetOperations setOperation = this.redisTemplate.boundSetOps((Object)key);
        for (T t : dataSet) {
            setOperation.add(new Object[]{t});
        }
        return setOperation;
    }

    public <T> Set<T> getCacheSet(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public <T> void setCacheMap(String key, Map<String, T> dataMap) {
        if (dataMap != null) {
            this.redisTemplate.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public <T> Map<String, T> getCacheMap(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public <T> void setCacheMapValue(String key, String hKey, T value) {
        this.redisTemplate.opsForHash().put((Object)key, (Object)hKey, value);
    }

    public <T> T getCacheMapValue(String key, String hKey) {
        HashOperations opsForHash = this.redisTemplate.opsForHash();
        return (T)opsForHash.get((Object)key, (Object)hKey);
    }

    public <T> List<T> getMultiCacheMapValue(String key, Collection<Object> hKeys) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, hKeys);
    }

    public Collection<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }
}

