/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.cache.redis.config;

import cn.hutool.core.collection.ConcurrentHashSet;
import cn.lingyangwl.framework.tool.core.CollectionUtils;
import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.Filter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;

public class FastJson2JsonRedisSerializer
implements RedisSerializer<Object> {
    public static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static final Set<String> AUTO_TYPE_FILTER_SET = new ConcurrentHashSet();
    private final Class<?> clazz;

    public FastJson2JsonRedisSerializer(Class<?> clazz) {
        this.clazz = clazz;
    }

    public byte[] serialize(Object t) throws SerializationException {
        if (t == null) {
            return new byte[0];
        }
        return JSON.toJSONString((Object)t, (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.WriteClassName}).getBytes(DEFAULT_CHARSET);
    }

    public static void addDeserializeAutoTypeFilter(String ... names) {
        if (CollectionUtils.isEmpty((Object[])names)) {
            return;
        }
        AUTO_TYPE_FILTER_SET.addAll(Arrays.stream(names).collect(Collectors.toSet()));
    }

    public Object deserialize(byte[] bytes) throws SerializationException {
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        String str = new String(bytes, DEFAULT_CHARSET);
        JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = JSONReader.autoTypeFilter((String[])AUTO_TYPE_FILTER_SET.toArray(new String[0]));
        return JSON.parseObject((String)str, this.clazz, (Filter)autoTypeBeforeHandler, (JSONReader.Feature[])new JSONReader.Feature[]{JSONReader.Feature.FieldBased, JSONReader.Feature.SupportAutoType});
    }

    protected JavaType getJavaType(Class<?> clazz) {
        return TypeFactory.defaultInstance().constructType(clazz);
    }
}

