/*
 * Decompiled with CFR 0.152.
 */
package cn.lingyangwl.framework.cache.redis.bloom_filter;

import cn.lingyangwl.framework.cache.redis.bloom_filter.RedisBloomFilterProperties;
import com.google.common.hash.Funnels;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Service;

@Service
public class RedisBloomFilter {
    private long numBits;
    private int numHashFunctions;
    @Resource
    private RedisTemplate redisTemplate;
    @Resource
    private RedisBloomFilterProperties redisBloomFilterProperties;

    @PostConstruct
    private void init() {
        this.numBits = this.optimalNumOfBits();
        this.numHashFunctions = this.optimalNumOfHashFunctions();
    }

    public void put(final String key, String value) {
        final long[] indexs = this.getIndexs(value);
        this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

            @Nullable
            public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                redisConnection.openPipeline();
                for (long index : indexs) {
                    redisConnection.setBit(key.getBytes(), index, true);
                }
                redisConnection.close();
                return null;
            }
        });
    }

    public boolean isExist(final String key, String value) {
        final long[] indexs = this.getIndexs(value);
        List list = this.redisTemplate.executePipelined((RedisCallback)new RedisCallback<Object>(){

            @Nullable
            public Object doInRedis(RedisConnection redisConnection) throws DataAccessException {
                redisConnection.openPipeline();
                for (long index : indexs) {
                    redisConnection.getBit(key.getBytes(), index);
                }
                redisConnection.close();
                return null;
            }
        });
        return !list.contains(false);
    }

    private long[] getIndexs(String vaule) {
        long hash1 = this.hash(vaule);
        long hash2 = hash1 >>> 16;
        long[] result = new long[this.numHashFunctions];
        for (int i = 0; i < this.numHashFunctions; ++i) {
            long combinedHash = hash1 + (long)i * hash2;
            if (combinedHash < 0L) {
                combinedHash ^= 0xFFFFFFFFFFFFFFFFL;
            }
            result[i] = combinedHash % this.numBits;
        }
        return result;
    }

    private long hash(String vaule) {
        Charset charset = Charset.defaultCharset();
        return Hashing.murmur3_128().hashObject((Object)vaule, Funnels.stringFunnel((Charset)charset)).asLong();
    }

    private long optimalNumOfBits() {
        if (this.redisBloomFilterProperties.getFpp() == 0.0) {
            this.redisBloomFilterProperties.setFpp(Double.MIN_VALUE);
        }
        return (long)((double)(-this.redisBloomFilterProperties.getExpectedInsertions()) * Math.log(this.redisBloomFilterProperties.getFpp()) / (Math.log(2.0) * Math.log(2.0)));
    }

    private int optimalNumOfHashFunctions() {
        return Math.max(1, (int)Math.round((double)this.numBits / (double)this.redisBloomFilterProperties.getExpectedInsertions() * Math.log(2.0)));
    }
}

