package cn.lingyangwl.framework.cache.core.key;

import java.util.concurrent.TimeUnit;

/**
 * <blockquote><pre>
 *  private final String key;
 *  private final int expire;
 *  private final TimeUnit unit;
 * </pre></blockquote>
 *
 * @author shenguangyang
 */
public interface ICacheKey {
    String getKey();

    int getExpire();

    TimeUnit getUnit();

    /**
     * key中的变量用%s代替, args就是每个变量
     */
    default String formatKey(Object... args) {
        return String.format(getKey(), args);
    }
}
