package cn.lingyangwl.framework.cache.core.key;

import lombok.Getter;

import java.util.concurrent.TimeUnit;

/**
 * @author shenguangyang
 */
@Getter
public enum DefaultCacheKey implements ICacheKey {
    TEST("login_tokens:%s", 720, TimeUnit.MINUTES),
    ;

    private final String key;
    private final int expire;
    private final TimeUnit unit;

    DefaultCacheKey(String key, int expire, TimeUnit unit) {
        this.key = key;
        this.expire = expire;
        this.unit = unit;
    }

    @Override
    public String formatKey(Object... args) {
        return String.format(this.key, args);
    }

    @Override
    public String getKey() {
        return key;
    }

    @Override
    public int getExpire() {
        return expire;
    }

    @Override
    public TimeUnit getUnit() {
        return unit;
    }
}
