/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.ldap;

import cn.liboss.ass.core.DateUtil;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.util.Hashtable;
import java.util.UUID;
import javax.naming.NamingEnumeration;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LDAPHelper {
    public static String LDAPUrl = "ldap://dms.yudean.com";
    public static String BaseDN = "OU=\u8302\u540d\u7535\u5382,OU=\u5e7f\u4e1c\u7ca4\u7535\u96c6\u56e2\u6709\u9650\u516c\u53f8,DC=dms,DC=yudean,DC=com";
    public static String adminUser = "mmad@dms.yudean.com";
    public static String adminPwd = "yudean123$";

    private static DirContext getDirContext(String ldapURL, String adminUser, String adminPwd) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", ldapURL);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", adminUser);
        env.put("java.naming.security.credentials", adminPwd);
        env.put("java.util.Date", "lastLogon badPasswordTime");
        env.put("java.naming.ldap.attributes.binary", "objectSid objectGUID");
        InitialDirContext ctx = null;
        try {
            ctx = new InitialDirContext(env);
        }
        catch (Exception ex) {
            System.out.println("AD\u57dfssl\u8eab\u4efd\u8ba4\u8bc1\u51fa\u9519");
            ex.printStackTrace();
        }
        return ctx;
    }

    public static void updatePassWord(String userName, String userNewPwd) throws Exception {
        DirContext ctx = LDAPHelper.getDirContext(LDAPUrl, adminUser, adminPwd);
        ModificationItem[] mods = new ModificationItem[1];
        String newQuotedPassword = "\"" + userNewPwd + "\"";
        byte[] newUnicodePassword = newQuotedPassword.getBytes("UTF-16LE");
        mods[0] = new ModificationItem(2, new BasicAttribute("unicodePwd", newUnicodePassword));
        ctx.modifyAttributes(userName, mods);
        System.out.println("Reset Password for: " + userName);
        ctx.close();
    }

    public static boolean simpleValidate(String username, String password) throws Exception {
        try {
            DirContext ctx = LDAPHelper.getDirContext(LDAPUrl, username, password);
            ctx.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static JSONArray getSubOUArrayByParentDN(String dn_fullname, boolean isIncludeSub) throws Exception {
        DirContext ctx = LDAPHelper.getDirContext(LDAPUrl, adminUser, adminPwd);
        SearchControls searchCtls = new SearchControls();
        if (isIncludeSub) {
            searchCtls.setSearchScope(2);
        } else {
            searchCtls.setSearchScope(1);
        }
        String searchFilter = "(&(objectClass=organizationalUnit))";
        NamingEnumeration<SearchResult> results = ctx.search(dn_fullname, searchFilter, searchCtls);
        JSONArray array = LDAPHelper.resultToOUArray(results);
        ctx.close();
        return array;
    }

    private static JSONArray resultToOUArray(NamingEnumeration<?> results) throws Exception {
        JSONArray array = new JSONArray();
        while (results.hasMoreElements()) {
            JSONObject json = new JSONObject();
            SearchResult sr = (SearchResult)results.next();
            Attributes attributes = sr.getAttributes();
            NamingEnumeration<? extends Attribute> a = attributes.getAll();
            while (a.hasMore()) {
                Attribute attribute = a.next();
                if ("objectGUID".equals(attribute.getID())) {
                    String s1 = UUID.nameUUIDFromBytes((byte[])attribute.get()).toString();
                    json.put((Object)"guid", (Object)s1);
                }
                if ("whenCreated_".equals(attribute.getID()) || "whenChanged_".equals(attribute.getID()) || "dSCorePropagationData_".equals(attribute.getID())) {
                    Long time1 = Long.parseLong(attribute.get().toString()) / 10000L - 11644473600000L;
                    json.put((Object)attribute.getID(), (Object)DateUtil.parseToTimestamp(time1));
                    continue;
                }
                json.put((Object)attribute.getID(), (Object)attribute.get().toString());
            }
            array.add((Object)json);
        }
        return array;
    }

    public static JSONArray getSubADUserByDN(String dn_fullname, boolean isIncludeSub) throws Exception {
        DirContext ctx = LDAPHelper.getDirContext(LDAPUrl, adminUser, adminPwd);
        SearchControls searchCtls = new SearchControls();
        if (isIncludeSub) {
            searchCtls.setSearchScope(2);
        } else {
            searchCtls.setSearchScope(1);
        }
        String searchFilter = "(&(objectClass=user))";
        NamingEnumeration<SearchResult> results = ctx.search(dn_fullname, searchFilter, searchCtls);
        JSONArray array = LDAPHelper.resultToADUserArray(results);
        ctx.close();
        return array;
    }

    private static JSONArray resultToADUserArray(NamingEnumeration<?> results) throws Exception {
        JSONArray array = new JSONArray();
        while (results.hasMoreElements()) {
            JSONObject json = new JSONObject();
            SearchResult sr = (SearchResult)results.next();
            Attributes attributes = sr.getAttributes();
            NamingEnumeration<? extends Attribute> a = attributes.getAll();
            while (a.hasMore()) {
                String s1;
                Attribute attribute = a.next();
                if ("objectGUID".equals(attribute.getID())) {
                    s1 = UUID.nameUUIDFromBytes((byte[])attribute.get()).toString();
                    json.put((Object)"guid", (Object)s1);
                    continue;
                }
                if ("objectSid".equals(attribute.getID())) {
                    s1 = UUID.nameUUIDFromBytes((byte[])attribute.get()).toString();
                    json.put((Object)"objectSid_ex", (Object)s1);
                    continue;
                }
                if ("lastLogon".equals(attribute.getID()) || "badPasswordTime".equals(attribute.getID()) || "pwdLastSet".equals(attribute.getID())) {
                    Long time1 = Long.parseLong(attribute.get().toString()) / 10000L - 11644473600000L;
                    json.put((Object)attribute.getID(), (Object)DateUtil.parseToTimestamp(time1));
                    continue;
                }
                json.put((Object)attribute.getID(), (Object)attribute.get().toString());
            }
            array.add((Object)json);
        }
        return array;
    }

    public static boolean isUserEnable(JSONObject jsonAdUser) {
        int userAccountControl = jsonAdUser.getIntValue("userAccountControl");
        return LDAPHelper.isUserEnable(userAccountControl);
    }

    public static boolean isUserEnable(int userAccountControl) {
        boolean isEnable = true;
        if (userAccountControl == 514 || userAccountControl == 546 || userAccountControl == 66050 || userAccountControl == 66080 || userAccountControl == 66082) {
            isEnable = false;
        }
        return isEnable;
    }
}

