/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.dao.codegenerate;

import cn.liboss.ass.core.FileUtil;
import cn.liboss.ass.dao.DBSession;
import cn.liboss.ass.dao.codegenerate.DBSessionImp;
import java.io.File;
import java.sql.ResultSetMetaData;

public class DaoCodeGenerate {
    public static void main(String[] args) throws Exception {
        String userName = "";
        String passWord = "";
        String saveFileDir = "D:\\Work_Project\\code04_mm\\Project2023_yx\\B_Code\\javagui\\khinfo_check\\src\\main\\java\\cn\\com\\weteam\\khinfo_check\\entity";
        String packageName = "cn.com.weteam.khinfo_check.entity";
        String tableOrViewName = "yx_check_rule";
        String pkFieldName = "rule_id";
        String entityName = "Yx_check_rule";
        DBSessionImp db = new DBSessionImp();
        DaoCodeGenerate.saveAndPrintPojo(db, saveFileDir, packageName, tableOrViewName, pkFieldName, entityName);
        db.closeConnection();
    }

    public static void printExtJsCode_GridField(String db_string_prix, String tableOrViewName) throws Exception {
        DBSession db = null;
        ResultSetMetaData md = db.getMataData(tableOrViewName);
        System.out.println("ExtJsCode_GridField:");
        System.out.println("[");
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String s = "\t{ name: '" + md.getColumnName(i).toLowerCase() + "', type: 'string' },";
            System.out.println(s);
        }
        System.out.println("]");
        System.out.println("--------------------------------");
        db.closeConnection();
    }

    public static void printColumnInfo(DBSession db, String tableOrViewName) throws Exception {
        ResultSetMetaData md = db.getMataData(tableOrViewName);
        System.out.println("printColumnInfo:");
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String s = "ColumnLabel : " + md.getColumnLabel(i) + " ,        ColumnName : " + md.getColumnName(i) + " , \t\tColumnClassName : " + md.getColumnClassName(i) + " , \tColumnTypeName : " + md.getColumnTypeName(i) + " , ColumnType : " + md.getColumnType(i) + " , ColumnDisplaySize : " + md.getColumnDisplaySize(i) + " , Scale : " + md.getScale(i) + " , Precision : " + md.getPrecision(i);
            System.out.println(s);
        }
        System.out.println("--------------------------------");
    }

    private static String getJavaClassNameByColumnType(String columnTypeName) {
        String javaClassName = "";
        if (columnTypeName.trim().equals("INTEGER")) {
            javaClassName = "Integer";
        } else if (columnTypeName.trim().equals("TEXT")) {
            javaClassName = "String";
        } else if (columnTypeName.trim().equals("NUMERIC")) {
            javaClassName = "Double";
        }
        return javaClassName;
    }

    public static void saveAndPrintPojo(DBSession db, String saveFileDir, String packageName, String tableOrViewName, String pkColumnName, String entityName) throws Exception {
        ResultSetMetaData md = db.getMataData(tableOrViewName);
        String text = "";
        String text_filed = "";
        String text_getset = "";
        text = text + "package " + packageName + ";\n\n";
        text = text + "import cn.com.weteam.ass.dao.annotation.EntityInfo;\n\n";
        text = text + "@EntityInfo(tableName = \"" + tableOrViewName + "\",pkFiledName = \"" + pkColumnName + "\") \n";
        text = text + "public class " + entityName + "{ \n";
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String sColumnName = md.getColumnName(i);
            String sColumnTypeName = md.getColumnTypeName(i);
            String sColumnClassName = md.getColumnClassName(i);
            int nDisplaySize = md.getColumnDisplaySize(i);
            int nPrecision = md.getPrecision(i);
            int nScale = md.getScale(i);
            String entity_field_className = "";
            String entity_field_fieldName = "";
            String entity_method_methodName = "";
            String entity_method_parmsName = "";
            entity_field_className = DaoCodeGenerate.getJavaClassNameByColumnType(sColumnTypeName);
            entity_field_fieldName = sColumnName.toLowerCase();
            entity_method_methodName = sColumnName.substring(0, 1).toUpperCase() + sColumnName.substring(1, sColumnName.length()).toLowerCase();
            entity_method_parmsName = sColumnName.toLowerCase();
            text_filed = text_filed + "\tprivate " + entity_field_className + " " + entity_field_fieldName + " ;\n";
            text_getset = text_getset + "\tpublic void set" + entity_method_methodName + "(" + entity_field_className + " " + entity_method_parmsName + "){\n";
            text_getset = text_getset + "\t\tthis." + entity_field_fieldName + "=" + entity_method_parmsName + ";\n";
            text_getset = text_getset + "\t}\n";
            text_getset = text_getset + "\tpublic " + entity_field_className + " get" + entity_method_methodName + "(){ \n";
            text_getset = text_getset + "\t\treturn this." + entity_field_fieldName + ";\n";
            text_getset = text_getset + "\t}\n\n";
        }
        text = text + text_filed;
        text = text + "\n";
        text = text + text_getset;
        text = text + "}";
        FileUtil.createTextFile(saveFileDir + File.separator + entityName + ".java", text);
        System.out.println(text);
        System.out.println("Save File : " + saveFileDir + File.separator + entityName + ".java");
    }

    public static void printCRUDSQL(DBSession db, String tableOrViewName, String pkColumnName) throws Exception {
        ResultSetMetaData md = db.getMataData(tableOrViewName);
        System.out.println("-----printCRUDSQL:-----");
        String sql_insert = DaoCodeGenerate.getSQL_Insert(md, tableOrViewName);
        System.out.println(sql_insert);
        String sql_update = DaoCodeGenerate.getSQL_Update(md, pkColumnName, tableOrViewName);
        System.out.println(sql_update);
        String sql_select = DaoCodeGenerate.getSQL_Select(md, tableOrViewName);
        System.out.println(sql_select);
        db.closeConnection();
    }

    private static String getSQL_Insert(ResultSetMetaData md, String tableOrViewName) throws Exception {
        StringBuilder sql_sub1 = new StringBuilder();
        StringBuilder sql_sub2 = new StringBuilder();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String sFieldName = md.getColumnName(i);
            sql_sub1.append(sFieldName + ",");
            sql_sub2.append("'" + sFieldName + "',");
            String string = "ColumnLabel : " + md.getColumnLabel(i) + " , ColumnName : " + md.getColumnName(i) + " , \t\tColumnClassName : " + md.getColumnClassName(i) + " , \tColumnTypeName : " + md.getColumnTypeName(i) + " , ColumnType : " + md.getColumnType(i) + " , ColumnDisplaySize : " + md.getColumnDisplaySize(i) + " , Scale : " + md.getScale(i) + " , Precision : " + md.getPrecision(i);
        }
        sql_sub1.deleteCharAt(sql_sub1.length() - 1);
        sql_sub2.deleteCharAt(sql_sub2.length() - 1);
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Insert into ").append(tableOrViewName);
        sSQL.append(" (").append(sql_sub1.toString()).append(") ");
        sSQL.append(" Values (").append(sql_sub2.toString()).append(") ");
        String sql_insert = sSQL.toString();
        return sql_insert;
    }

    private static String getSQL_Update(ResultSetMetaData md, String pkColumnName, String tableOrViewName) throws Exception {
        StringBuilder sql_sub1 = new StringBuilder();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String sFieldName = md.getColumnName(i);
            if (pkColumnName.toUpperCase().equals(sFieldName.toUpperCase())) continue;
            sql_sub1.append(sFieldName + "='" + sFieldName + "',");
        }
        sql_sub1.deleteCharAt(sql_sub1.length() - 1);
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Update ").append(tableOrViewName);
        sSQL.append(" Set ").append(sql_sub1.toString()).append(" ");
        sSQL.append(" Where ").append(pkColumnName).append("='" + pkColumnName + "' ");
        String sql = sSQL.toString();
        return sql;
    }

    private static String getSQL_Select(ResultSetMetaData md, String tableOrViewName) throws Exception {
        StringBuilder sql_sub1 = new StringBuilder();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String sFieldName = md.getColumnName(i);
            sql_sub1.append(sFieldName + ",");
        }
        sql_sub1.deleteCharAt(sql_sub1.length() - 1);
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Select " + sql_sub1.toString() + " From " + tableOrViewName);
        String sql = sSQL.toString();
        return sql;
    }
}

