/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.core;

import cn.liboss.ass.core.OrderedProperties;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    private static Properties propertiesFile = null;
    private static Properties propertiesActiveFile = null;
    private static String classesPath = null;

    public static void createTextFile(String filePath, String content) throws IOException {
        FileUtil.createTextFile(filePath, content, "UTF-8");
    }

    public static void createTextFile(String filePath, String content, String Charset2) throws IOException {
        OutputStreamWriter write = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), Charset2);
        write.write(content);
        write.flush();
        write.close();
    }

    public static void createFile(String filePath, InputStream inputStream) throws IOException {
        int bytes_read;
        FileOutputStream fout = new FileOutputStream(filePath);
        byte[] buffer = new byte[4096];
        while ((bytes_read = inputStream.read(buffer)) != -1) {
            fout.write(buffer, 0, bytes_read);
        }
        if (fout != null) {
            fout.close();
        }
    }

    public static void createFile(String filePath, byte[] byteArray) throws IOException {
        File file = new File(filePath);
        FileOutputStream fout = new FileOutputStream(file);
        fout.write(byteArray);
        if (fout != null) {
            fout.close();
        }
    }

    public static String readTextFileByUTF8(String fileName) throws Exception {
        String text = FileUtil.readTextFile(fileName, "UTF-8");
        return text;
    }

    public static String readTextFile(String filePath, String Charset2) throws Exception {
        File f1 = new File(filePath);
        FileInputStream in = new FileInputStream(f1);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)in, Charset2));
        String str = br.readLine();
        StringBuffer sb = new StringBuffer();
        while (str != null) {
            sb.append(str + "\n");
            str = br.readLine();
        }
        in.close();
        return sb.toString();
    }

    public static byte[] readFileBytes(String filePath) throws IOException {
        byte[] buffer = null;
        File file = new File(filePath);
        if (file.exists()) {
            FileInputStream inStream = new FileInputStream(file);
            buffer = new byte[((InputStream)inStream).available()];
            ((InputStream)inStream).read(buffer);
            ((InputStream)inStream).close();
        }
        return buffer;
    }

    public static byte[] readZipFirstFileBytes(String zipFilePath) throws IOException {
        File zipFile = new File(zipFilePath);
        byte[] bytes = null;
        try (FileInputStream zipFile_is = new FileInputStream(zipFile);){
            bytes = FileUtil.readZipStreamFirstFileBytes(zipFile_is);
        }
        return bytes;
    }

    public static byte[] readZipStreamFirstFileBytes(InputStream zipFile) throws IOException {
        ZipEntry entry;
        byte[] bytes = null;
        ZipInputStream zis = new ZipInputStream(zipFile);
        byte[] buffer = new byte[10240];
        while ((entry = zis.getNextEntry()) != null) {
            if (entry.getName().endsWith(File.separator)) continue;
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
                int len;
                while ((len = zis.read(buffer)) > 0) {
                    bos.write(buffer, 0, len);
                }
                bytes = bos.toByteArray();
                zis.closeEntry();
                break;
            }
        }
        return bytes;
    }

    public static void createFolder(String folderPath) throws Exception {
        File folder = new File(folderPath);
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new Exception("\u76f8\u540c\u4f4d\u7f6e\u5b58\u5728\u540c\u540d\u6587\u4ef6\u4e14\u4e0d\u662f\u76ee\u5f55\uff0c\u8bf7\u5220\u9664\u6587\u4ef6!");
            }
        } else {
            boolean isMkdir = folder.mkdirs();
            if (!isMkdir) {
                throw new Exception("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25! " + folder.getCanonicalPath());
            }
        }
    }

    public static void createFolders(String folderPath) throws Exception {
        File folder = new File(folderPath);
        if (folder.exists()) {
            if (!folder.isDirectory()) {
                throw new Exception("\u76f8\u540c\u4f4d\u7f6e\u5b58\u5728\u540c\u540d\u6587\u4ef6\u4e14\u4e0d\u662f\u76ee\u5f55\uff0c\u8bf7\u5220\u9664\u6587\u4ef6!");
            }
        } else {
            boolean isMkdir = folder.mkdirs();
            if (!isMkdir) {
                throw new Exception("\u6587\u4ef6\u5939\u521b\u5efa\u5931\u8d25! " + folderPath);
            }
        }
    }

    public static void delFile(String filePath) throws IOException {
        File file1 = new File(filePath);
        boolean isDelete = file1.delete();
        if (!isDelete) {
            throw new IOException("\u5220\u9664" + file1.getPath() + "\u6587\u4ef6\u5931\u8d25!");
        }
    }

    public static void delAllFile(String folderPath) throws IOException {
        File file = new File(folderPath);
        if (!file.exists()) {
            return;
        }
        if (!file.isDirectory()) {
            return;
        }
        File[] tempList = file.listFiles();
        for (int i = 0; i < tempList.length; ++i) {
            File temp = tempList[i];
            if (temp.isFile()) {
                try {
                    FileUtil.delFile(temp.getCanonicalPath());
                }
                catch (Exception ex) {
                    System.out.println("\u5220\u9664" + temp.getPath() + "\u6587\u4ef6\u5931\u8d25!");
                }
                continue;
            }
            if (!temp.isDirectory()) continue;
            FileUtil.delFolder(temp.getCanonicalPath());
        }
    }

    public static void delFolder(String folderPath) throws IOException {
        FileUtil.delAllFile(folderPath);
        File folder = new File(folderPath);
        Boolean isDelete = folder.delete();
        if (!isDelete.booleanValue()) {
            throw new IOException("\u5220\u9664\u6587\u4ef6\u5939\u5931\u8d25!" + folderPath);
        }
    }

    public static void copyFile(String oldPath, String newPath) throws IOException {
        int byteread = 0;
        File file1 = new File(oldPath);
        File file2 = new File(newPath);
        FileInputStream inStream = new FileInputStream(file1);
        FileOutputStream fs = new FileOutputStream(file2);
        byte[] buffer = new byte[1024];
        while ((byteread = ((InputStream)inStream).read(buffer)) != -1) {
            fs.write(buffer, 0, byteread);
        }
        ((InputStream)inStream).close();
        fs.close();
    }

    public static void copyFolder(String oldDirPath, String newDirPath) throws IOException {
        File newDir1 = new File(newDirPath);
        newDir1.mkdirs();
        File oldFile = new File(oldDirPath);
        File[] file = oldFile.listFiles();
        File temp = null;
        for (int i = 0; i < file.length; ++i) {
            temp = file[i];
            if (temp.isFile()) {
                String newPath = newDirPath + File.separator + temp.getName();
                File newFile = new File(newPath);
                FileUtil.copyFile(temp.getCanonicalPath(), newFile.getCanonicalPath());
                continue;
            }
            if (!temp.isDirectory()) continue;
            FileUtil.copyFolder(temp.getCanonicalPath(), newDirPath + File.separator + file[i].getName());
        }
    }

    public static void moveFile(String oldFilePath, String newFilePath) throws IOException {
        FileUtil.copyFile(oldFilePath, newFilePath);
        FileUtil.delFile(oldFilePath);
    }

    public static void moveFolder(String oldPath, String newPath) throws IOException {
        FileUtil.copyFolder(oldPath, newPath);
        FileUtil.delFolder(oldPath);
    }

    public static void moveAndZipFileToDir(File srcFile, String bakupDir) throws Exception {
        FileUtil.moveAndZipFileToDir(srcFile, bakupDir, true);
    }

    public static void moveAndZipFileToDir(File srcFile, String bakupDir, Boolean isExtentionLowerCase) throws Exception {
        boolean isCreated;
        File bakupDirObj = new File(bakupDir);
        if (!bakupDirObj.isDirectory() && !(isCreated = bakupDirObj.mkdir())) {
            throw new Exception("\u521b\u5efa\u76ee\u5f55\u5931\u8d25\uff1a" + bakupDirObj.getCanonicalPath());
        }
        String extention = ".zip";
        if (!isExtentionLowerCase.booleanValue()) {
            extention = ".ZIP";
        }
        String zipFileName = bakupDirObj.getCanonicalPath() + "/" + srcFile.getName() + extention;
        FileUtil.zip(zipFileName, srcFile.getCanonicalPath());
        if (!srcFile.canRead() || !srcFile.canWrite()) {
            throw new Exception("\u79fb\u52a8\u6587\u4ef6\u540e\uff0c\u6e90\u6587\u4ef6\u65e0\u6cd5\u5220\u9664\uff01" + srcFile.getCanonicalPath());
        }
        FileUtil.delFile(srcFile.getCanonicalPath());
    }

    public static String getSystemProperties(String propertyKey) throws IOException {
        String result = FileUtil.getSystemProperties(propertyKey, true);
        return result;
    }

    public static String getSystemProperties(String propertyKey, boolean isFromCache) throws IOException {
        String profile_suffix;
        if (isFromCache) {
            if (propertiesFile == null && (profile_suffix = (propertiesFile = FileUtil.getSystemPropertiesFile()).getProperty("system.profiles.active")) != null && !profile_suffix.equals("")) {
                propertiesActiveFile = FileUtil.getSystemPropertiesActiveFile(profile_suffix);
            }
        } else {
            propertiesFile = FileUtil.getSystemPropertiesFile();
            profile_suffix = propertiesFile.getProperty("system.profiles.active");
            if (profile_suffix != null && !profile_suffix.equals("")) {
                propertiesActiveFile = FileUtil.getSystemPropertiesActiveFile(profile_suffix);
            }
        }
        String value = "";
        if (propertiesActiveFile != null) {
            value = propertiesActiveFile.getProperty(propertyKey);
        }
        if (value == null || value.equals("")) {
            value = propertiesFile.getProperty(propertyKey);
        }
        String result = null;
        result = value != null ? new String(value.getBytes("ISO8859-1"), "utf-8") : null;
        return result;
    }

    private static Properties getSystemPropertiesActiveFile(String profile_suffix) throws IOException {
        String classPath = FileUtil.getClassLoaderPath() + "/system-" + profile_suffix + ".properties";
        File file1 = new File(classPath);
        FileInputStream input = new FileInputStream(file1);
        Properties propertiesFile = new Properties();
        propertiesFile.load(input);
        ((InputStream)input).close();
        return propertiesFile;
    }

    private static String getClassLoaderPath_v1() {
        if (classesPath == null || classesPath.equals("")) {
            URL url = Thread.currentThread().getContextClassLoader().getResource("");
            if (url != null) {
                classesPath = url.getPath();
                System.out.println("ClassLoader\u8def\u5f84=" + classesPath);
            } else {
                classesPath = System.getProperty("user.dir");
                System.out.println("user.dir\u8def\u5f84=" + classesPath);
            }
            classesPath = classesPath.replace("file:", "");
            while (classesPath.toLowerCase().indexOf(".jar!") > 0 || classesPath.toLowerCase().indexOf(".war!") > 0) {
                File path = new File(classesPath);
                classesPath = path.getParent();
            }
            System.out.println("\u5f53\u524d\u7a0b\u5e8f\u8def\u5f84(\u53bb\u9664file\u548cjar/war\u4e4b\u540e)=" + classesPath);
        }
        return classesPath;
    }

    public static String getClassLoaderPath() {
        if (classesPath == null || classesPath.equals("")) {
            URL url = Thread.currentThread().getContextClassLoader().getResource("");
            classesPath = url != null ? url.getPath() : System.getProperty("user.dir");
            classesPath = classesPath.replace("file:", "");
            File path = new File(classesPath);
            try {
                classesPath = path.isDirectory() || path.getCanonicalPath().endsWith(File.separator) ? path.getCanonicalPath() : path.getParent();
                System.out.println("\u7a0b\u5e8f\u542f\u52a8\u8def\u5f84 = " + classesPath);
            }
            catch (IOException ex) {
                System.out.println("error : classesPath=" + classesPath);
                ex.printStackTrace();
            }
        }
        return classesPath;
    }

    public static Properties getSystemPropertiesFile() throws IOException {
        String classPath = FileUtil.getClassLoaderPath() + "/system.properties";
        File file1 = new File(classPath);
        FileInputStream input = new FileInputStream(file1);
        OrderedProperties propertiesFile = new OrderedProperties();
        propertiesFile.load(input);
        ((InputStream)input).close();
        return propertiesFile;
    }

    public static void propFileSave(Properties properties) throws IOException {
        String filePath = FileUtil.getClassLoaderPath() + "/system.properties";
        try (FileOutputStream output = new FileOutputStream(filePath);){
            properties.store(output, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public static String getFileName(String fullFileName) {
        File file1 = new File(fullFileName);
        String fielName = file1.getName();
        if (fielName.contains(".") && fielName.lastIndexOf(".") < fielName.length() - 1) {
            fielName = fielName.substring(0, fielName.lastIndexOf("."));
        }
        return fielName;
    }

    public static void zipOfMultiple(File destFile, List<File> srcFilesList) throws Exception {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destFile));){
            for (File file : srcFilesList) {
                if (file == null || !file.exists()) {
                    System.out.println(file.getPath() + ",\u6587\u4ef6\u4e3anull\u6216exists=false");
                    continue;
                }
                FileUtil.zipCompress(zos, file, file.getName());
            }
        }
    }

    public static void zip(String destFilePath, String srcFilesPath) throws Exception {
        File destFile = new File(destFilePath);
        File srcFiles = new File(srcFilesPath);
        FileUtil.zip(destFile, srcFiles);
    }

    public static void zip(File destFile, File srcFile) throws Exception {
        try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(destFile));){
            FileUtil.zipCompress(zos, srcFile, srcFile.getName());
        }
    }

    private static void zipCompress(ZipOutputStream zipOs, File srcFile, String zipEntryName) throws Exception {
        if (srcFile.isDirectory()) {
            zipOs.putNextEntry(new ZipEntry(zipEntryName + File.separator));
            zipOs.closeEntry();
            for (File subFile : srcFile.listFiles()) {
                String subZipEntryName = zipEntryName + File.separator + subFile.getName();
                FileUtil.zipCompress(zipOs, subFile, subZipEntryName);
            }
            return;
        }
        zipOs.putNextEntry(new ZipEntry(zipEntryName));
        try (FileInputStream inputStream = new FileInputStream(srcFile);){
            int len;
            byte[] buf = new byte[4096];
            while ((len = inputStream.read(buf)) != -1) {
                zipOs.write(buf, 0, len);
            }
        }
        zipOs.closeEntry();
    }

    public static void unZipToFolder(String zipFilePath, String outputFolderPath) throws IOException {
        ZipEntry entry;
        FileInputStream zipFile_is = new FileInputStream(zipFilePath);
        ZipInputStream zis = new ZipInputStream(zipFile_is);
        byte[] buffer = new byte[4096];
        File outputFolder = new File(outputFolderPath);
        while ((entry = zis.getNextEntry()) != null) {
            File outputFile = new File(outputFolder.getCanonicalPath() + File.separatorChar + entry.getName());
            File outputParent = new File(outputFile.getParent());
            outputParent.mkdirs();
            if (entry.getName().endsWith(File.separator)) {
                if (!outputFile.exists()) {
                    outputFile.mkdir();
                }
            } else {
                try (FileOutputStream fos = new FileOutputStream(outputFile);){
                    int len;
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                }
            }
            zis.closeEntry();
        }
    }
}

