/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.core;

import cn.liboss.ass.constants.DBMSName;
import cn.liboss.ass.core.JsonUtil;
import cn.liboss.ass.core.StringUtil;
import cn.liboss.ass.dao.PageInfo;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDAO {
    Logger logger = LogManager.getLogger((Object)this);
    private boolean isPrintSql = true;
    protected Connection objConn = null;

    public void setPrintSql(boolean isPrint) {
        this.isPrintSql = isPrint;
    }

    public boolean getPrintSql(boolean isPrint) {
        return this.isPrintSql;
    }

    private void printSql(String sql, Object paramsValuesArray) {
        if (this.isPrintSql) {
            String text = "";
            text = paramsValuesArray == null ? " SQL : " + sql : " SQL : " + sql + ((List)paramsValuesArray).toArray();
            StringUtil.printlnTimeAndText(text, this.getClass());
        }
    }

    private void printErrorSql(String sql, Object paramsValuesArray) {
        if (!this.isPrintSql) {
            String text = "";
            text = paramsValuesArray == null ? " ErrorSQL : " + sql : " ErrorSQL : " + sql + ((List)paramsValuesArray).toArray();
            StringUtil.printlnTimeAndText(text, this.getClass());
        }
    }

    public synchronized int getIntPkIdByConfigTable(String config_table_name, String table_name) {
        table_name = table_name.toLowerCase();
        int pkid = 0;
        String updateSQL = "update " + config_table_name + " set pk_value=pk_value+1 where table_name='" + StringUtil.sqlFilter(table_name) + "'";
        int rows = this.executeUpdate(updateSQL);
        if (rows > 0) {
            String sql = "select pk_value from " + config_table_name + " where table_name='" + StringUtil.sqlFilter(table_name) + "'";
            JSONArray array = this.query(sql);
            pkid = array.getJSONObject(0).getIntValue("pk_value");
        } else {
            String insertSQL = "insert into " + config_table_name + "(table_name,pk_value) values ('" + StringUtil.sqlFilter(table_name) + "',1) ";
            this.executeUpdate(insertSQL);
            pkid = 1;
        }
        return pkid;
    }

    public abstract Connection getConnection() throws Exception;

    public abstract String getDBType();

    public void closeConnection() {
        try {
            if (this.objConn != null) {
                this.objConn.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int executeUpdate(String sql) {
        int count = this.executeUpdate(sql, null);
        return count;
    }

    public int executeUpdate(String sql, List<Object> pramValues) {
        this.printSql(sql, pramValues);
        this.closeConnection();
        int count = 0;
        try {
            this.objConn = this.getConnection();
            PreparedStatement objPreState = this.objConn.prepareStatement(sql);
            if (pramValues != null) {
                for (int i = 0; i < pramValues.size(); ++i) {
                    objPreState.setObject(i + 1, pramValues.get(i));
                }
            }
            count = objPreState.executeUpdate();
        }
        catch (Exception ex) {
            this.printErrorSql(sql, pramValues);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeConnection();
        }
        return count;
    }

    public void executeUpdateBatch(String sql, List<List<Object>> paramsValuesArray, int batch_page_size, boolean batch_isInBatchCommit) {
        this.printSql(sql, paramsValuesArray);
        PreparedStatement objPreState = null;
        try (Connection objConn = this.getConnection();){
            objConn.setAutoCommit(false);
            objPreState = objConn.prepareStatement(sql);
            for (int m = 0; m < paramsValuesArray.size(); ++m) {
                List<Object> params = paramsValuesArray.get(m);
                if (params != null) {
                    for (int i = 0; i < params.size(); ++i) {
                        objPreState.setObject(i + 1, params.get(i));
                    }
                }
                objPreState.addBatch();
                if ((m + 1) % batch_page_size != 0) continue;
                if (batch_isInBatchCommit) {
                    try {
                        objPreState.executeBatch();
                        objConn.commit();
                    }
                    catch (Exception ex) {
                        String text = " \u6309\u6279\u6b21\u63d0\u4ea4\u6570\u636e\u65f6\u51fa\u9519\uff0c\u4e0d\u5f71\u54cd\u540e\u7eed\u5904\u7406!\u6bcf\u6279\u6570\u91cf" + batch_page_size + ",\u51fa\u9519\u4f4d\u7f6e" + (m + 1) + ",\u603b\u6570\u636e\u91cf" + paramsValuesArray.size() + "\u3002\u51fa\u9519\u539f\u56e0: " + ex.getMessage();
                        StringUtil.printlnTimeAndText(text, this.getClass());
                    }
                    continue;
                }
                objPreState.executeBatch();
            }
            if (batch_isInBatchCommit) {
                try {
                    objPreState.executeBatch();
                    objConn.commit();
                }
                catch (Exception ex) {
                    String text = " \u6309\u6279\u6b21\u63d0\u4ea4\u6570\u636e\u65f6\u51fa\u9519\uff0c\u4e0d\u5f71\u54cd\u540e\u7eed\u5904\u7406!\u6bcf\u6279\u6570\u91cf" + batch_page_size + ",\u51fa\u9519\u4f4d\u7f6e" + paramsValuesArray.size() + ",\u603b\u6570\u636e\u91cf" + paramsValuesArray.size() + "\u3002\u51fa\u9519\u539f\u56e0: " + ex.getMessage();
                    StringUtil.printlnTimeAndText(text, this.getClass());
                }
            } else {
                objPreState.executeBatch();
                objConn.commit();
            }
        }
        catch (Exception ex) {
            this.printErrorSql(sql, paramsValuesArray);
            throw new RuntimeException(ex);
        }
    }

    public void executeUpdateBatch(String sql, List<List<Object>> paramsValuesArray) {
        this.printSql(sql, paramsValuesArray);
        this.closeConnection();
        try {
            this.objConn = this.getConnection();
            this.objConn.setAutoCommit(false);
            PreparedStatement objPreState = this.objConn.prepareStatement(sql);
            for (int m = 0; m < paramsValuesArray.size(); ++m) {
                List<Object> params = paramsValuesArray.get(m);
                if (params != null) {
                    for (int i = 0; i < params.size(); ++i) {
                        objPreState.setObject(i + 1, params.get(i));
                    }
                }
                objPreState.addBatch();
            }
            objPreState.executeBatch();
            this.objConn.commit();
        }
        catch (Exception ex) {
            this.printErrorSql(sql, paramsValuesArray);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeConnection();
        }
    }

    public ResultSet getResultSet(Connection objConn, String sql) {
        return this.getResultSet(objConn, sql, null);
    }

    public ResultSet getResultSet(Connection objConn, String sql, List paramValues) {
        this.printSql(sql, paramValues);
        try {
            ResultSet objRS;
            PreparedStatement objPreState = objConn.prepareStatement(sql);
            if (paramValues != null) {
                for (int i = 0; i < paramValues.size(); ++i) {
                    objPreState.setObject(i + 1, paramValues.get(i));
                }
            }
            ResultSet resultSet = objRS = objPreState.executeQuery();
            return resultSet;
        }
        catch (Exception ex) {
            this.printErrorSql(sql, paramValues);
            throw new RuntimeException(ex);
        }
    }

    public void printColumnInfo(String tableOrViewName) {
        try {
            this.objConn = this.getConnection();
            ResultSet rs = this.getResultSet(this.objConn, "select * from " + tableOrViewName);
            ResultSetMetaData md = rs.getMetaData();
            System.out.println("printColumnInfo:");
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String s = "ColumnLabel : " + md.getColumnLabel(i) + " , ColumnName : " + md.getColumnName(i) + " , \t\tColumnClassName : " + md.getColumnClassName(i) + " , \tColumnTypeName : " + md.getColumnTypeName(i) + " , ColumnType : " + md.getColumnType(i) + " , ColumnDisplaySize : " + md.getColumnDisplaySize(i) + " , Scale : " + md.getScale(i) + " , Precision : " + md.getPrecision(i);
                System.out.println(s);
            }
            rs.close();
        }
        catch (Exception ex) {
            this.closeConnection();
        }
    }

    protected String buildSQLSelect(String tableOrViewOrSQLView, String whereString, String orderBy) {
        String sql = "Select * From " + tableOrViewOrSQLView;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString;
        }
        if (orderBy.trim().length() > 0) {
            sql = sql + " Order by " + orderBy;
        }
        return sql;
    }

    public JSONArray query(String tableOrViewOrSQLView, String whereString, String orderBy) {
        String sql = this.buildSQLSelect(tableOrViewOrSQLView, whereString, orderBy);
        return this.query(sql);
    }

    public List<HashMap<String, Object>> queryToMap(String tableOrViewOrSQLView, String whereString, String orderBy) {
        List<HashMap<String, Object>> list = null;
        try {
            this.objConn = this.getConnection();
            String sql = this.buildSQLSelect(tableOrViewOrSQLView, whereString, orderBy);
            ResultSet rs = this.getResultSet(this.objConn, sql);
            list = this.resultSetToMapList(rs);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        finally {
            this.closeConnection();
        }
        return list;
    }

    public <T> List queryToList(String tableOrViewOrSQLView, String whereString, String orderBy, Class<T> objectClass) {
        return this.queryPageDataEntityList(tableOrViewOrSQLView, whereString, orderBy, 0, Integer.MAX_VALUE, objectClass);
    }

    public JSONObject getOneJson(String tableOrViewOrSQLView, String whereString) {
        String sql = this.buildSQLSelect(tableOrViewOrSQLView, whereString, "");
        JSONArray jsonArray = this.query(sql);
        JSONObject json = null;
        if (jsonArray.size() > 0) {
            json = jsonArray.getJSONObject(0);
        }
        return json;
    }

    public <T> T getOneEntity(String tableOrViewOrSQLView, String whereString, Class<T> tClass) {
        JSONObject json = this.getOneJson(tableOrViewOrSQLView, whereString);
        T entity1 = JsonUtil.castJSONObjectToEntity(json, tClass);
        return entity1;
    }

    public JSONArray query(String sql) {
        JSONArray jsonArray = null;
        try (Connection objConn = this.getConnection();
             ResultSet rs = this.getResultSet(objConn, sql);){
            jsonArray = BaseDAO.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return jsonArray;
    }

    public JSONArray query(String sql, List pramValues) {
        JSONArray jsonArray = null;
        try (Connection objConn = this.getConnection();
             ResultSet rs = this.getResultSet(objConn, sql, pramValues);){
            jsonArray = BaseDAO.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        return jsonArray;
    }

    public int getRowCount(String tableOrViewName, String whereString) {
        String sql = "Select count(1) as rowcount From " + tableOrViewName;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString.trim();
        }
        int n = this.query(sql).getJSONObject(0).getInteger("rowcount");
        return n;
    }

    public long getRowCountLong(String tableOrViewName, String whereString) {
        String sql = "Select count(1) as rowcount From " + tableOrViewName;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString.trim();
        }
        long n = this.query(sql).getJSONObject(0).getLong("rowcount");
        return n;
    }

    public JSONArray queryPageDataJsonArray(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize) {
        if (whereString.trim().length() > 0) {
            whereString = " where " + whereString.trim();
        }
        if (orderBy.trim().length() > 0) {
            orderBy = " Order By " + orderBy;
        }
        String sql = "";
        JSONArray jsonArray = null;
        try {
            this.objConn = this.getConnection();
            Statement objState = this.objConn.createStatement();
            sql = this.getPageSQL(tableOrViewOrSQLView, whereString, orderBy, pageNo, pageSize);
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet rs = objState.executeQuery(sql);
            jsonArray = BaseDAO.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeConnection();
        }
        return jsonArray;
    }

    public <T> List queryPageDataEntityList(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize, Class<T> objectClass) {
        JSONArray jsonArray = this.queryPageDataJsonArray(tableOrViewOrSQLView, whereString, orderBy, pageNo, pageSize);
        List<T> list1 = JsonUtil.castJSONArrayToEntityList(jsonArray, objectClass);
        return list1;
    }

    public PageInfo queryPageInfo(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize) {
        JSONArray jsonArray;
        if (whereString.trim().length() > 0) {
            whereString = " where " + whereString.trim();
        }
        if (orderBy.trim().length() > 0) {
            orderBy = " Order By " + orderBy;
        }
        String sql = "";
        long totalCount = 0L;
        long pageCount = 0L;
        try {
            this.objConn = this.getConnection();
            Statement objState = this.objConn.createStatement();
            sql = this.getPageSQL(tableOrViewOrSQLView, whereString, orderBy, pageNo, pageSize);
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet rs = objState.executeQuery(sql);
            jsonArray = BaseDAO.resultSetToJSONArray(rs);
            sql = "Select count(1) as ROWCOUNT From " + tableOrViewOrSQLView + whereString;
            ResultSet rsCount = objState.executeQuery(sql);
            rsCount.next();
            totalCount = rsCount.getLong(1);
            pageCount = totalCount / (long)pageSize;
            if (totalCount % (long)pageSize > 0L) {
                ++pageCount;
            }
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeConnection();
        }
        PageInfo page = new PageInfo();
        page.totalCount = totalCount;
        page.pageCount = pageCount;
        page.pageSize = pageSize;
        page.currentPageNo = pageNo;
        page.pageData = jsonArray;
        page.pageList = null;
        return page;
    }

    private String getPageSQL(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize) {
        StringBuffer sb = new StringBuffer();
        if (this.getDBType().equalsIgnoreCase(DBMSName.MSSQLSERVER)) {
            sb.append("Select top " + pageSize + " * From ");
            sb.append(" (select ROW_NUMBER() OVER ( " + orderBy + " ) as RowNo,*  from " + tableOrViewOrSQLView + " " + whereString + " ) db_pagesql_view2 ");
            sb.append(" where RowNo> " + (pageNo - 1) * pageSize);
        } else if (this.getDBType().equalsIgnoreCase(DBMSName.ORACLE)) {
            sb.append("SELECT * FROM ( SELECT ROWNUM Table_RowNum , db_pagesql_view1.* FROM " + tableOrViewOrSQLView + " db_pagesql_view1 " + whereString + " ) db_pagesql_view2  WHERE Table_RowNum <= " + pageNo * pageSize + " and Table_RowNum > " + (pageNo - 1) * pageSize + orderBy);
        } else if (this.getDBType().equalsIgnoreCase(DBMSName.DAMENG)) {
            sb.append("SELECT * FROM ( SELECT ROWNUM Table_RowNum , db_pagesql_view1.* FROM " + tableOrViewOrSQLView + " db_pagesql_view1 " + whereString + " ) db_pagesql_view2  WHERE Table_RowNum <= " + pageNo * pageSize + " and Table_RowNum > " + (pageNo - 1) * pageSize + orderBy);
        } else if (this.getDBType().equalsIgnoreCase(DBMSName.MYSQL)) {
            sb.append("SELECT * FROM " + tableOrViewOrSQLView + whereString + orderBy + " limit " + pageSize + " offset " + (pageNo - 1) * pageSize);
        } else if (this.getDBType().equalsIgnoreCase(DBMSName.SQLITE)) {
            sb.append("SELECT * FROM " + tableOrViewOrSQLView + whereString + orderBy + " limit " + pageSize + " offset " + (pageNo - 1) * pageSize);
        }
        return sb.toString();
    }

    public List<HashMap<String, Object>> resultSetToMapList(ResultSet rs) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String sColumnName = md.getColumnName(i);
                String sColumnClassName = md.getColumnClassName(i);
                String key_name = sColumnName.toLowerCase();
                if (sColumnClassName.toUpperCase().indexOf("CLOB") > 0) {
                    try {
                        Clob clob = (Clob)rs.getObject(sColumnName);
                        if (clob != null) {
                            String value1 = BaseDAO.clobToString(clob);
                            hashMap.put(key_name, value1);
                            continue;
                        }
                        hashMap.put(key_name, null);
                    }
                    catch (Exception ex1) {
                        ex1.printStackTrace();
                    }
                    continue;
                }
                hashMap.put(key_name, rs.getObject(sColumnName));
            }
            list.add(hashMap);
        }
        return list;
    }

    public static JSONArray resultSetToJSONArray(ResultSet rs) throws Exception {
        JSONArray jsonArray = new JSONArray();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            JSONObject json = new JSONObject();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String sColumnName = md.getColumnName(i);
                String sColumnClassName = md.getColumnClassName(i);
                String sColumnTypeName = md.getColumnTypeName(i);
                String key_name = sColumnName.toLowerCase();
                if (sColumnClassName.equals("java.lang.String") || sColumnClassName.equals("java.lang.Boolean") || sColumnClassName.equals("java.sql.Timestamp") || sColumnClassName.equals("java.util.Date") || sColumnClassName.equals("java.time.LocalDateTime") || sColumnClassName.equals("java.lang.Float") || sColumnClassName.equals("java.lang.Double") || sColumnClassName.equals("java.lang.Integer") || sColumnClassName.equals("java.lang.Short") || sColumnClassName.equals("java.lang.Byte") || sColumnClassName.equals("java.lang.Long") || sColumnClassName.equals("java.math.BigDecimal") || sColumnClassName.equals("java.math.BigInteger")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                if (sColumnClassName.equals("oracle.sql.INTERVALDS") || sColumnClassName.equals("oracle.sql.INTERVALYM") || sColumnClassName.equals("oracle.sql.TIMESTAMP") || sColumnClassName.equals("oracle.sql.TIMESTAMPLTZ") || sColumnClassName.equals("oracle.sql.TIMESTAMPTZ")) {
                    json.put((Object)key_name, (Object)rs.getTimestamp(i));
                    continue;
                }
                if (sColumnClassName.equals("oracle.sql.BINARY_DOUBLE") || sColumnClassName.equals("oracle.sql.BINARY_FLOAT")) {
                    json.put((Object)key_name, (Object)rs.getBigDecimal(i));
                    continue;
                }
                if (sColumnClassName.equals("oracle.jdbc.OracleClob") || sColumnClassName.equals("oracle.jdbc.OracleNClob")) {
                    Clob clob = (Clob)rs.getObject(sColumnName);
                    if (clob != null) {
                        String value1 = BaseDAO.clobToString(clob);
                        json.put((Object)key_name, (Object)value1);
                        continue;
                    }
                    json.put((Object)key_name, (Object)clob);
                    continue;
                }
                if (sColumnClassName.equals("oracle.jdbc.OracleBlob")) {
                    Blob blob = (Blob)rs.getObject(sColumnName);
                    if (blob != null) {
                        byte[] byte1 = BaseDAO.BlobToBytes(blob);
                        json.put((Object)key_name, (Object)byte1);
                        continue;
                    }
                    json.put((Object)key_name, (Object)blob);
                    continue;
                }
                if (sColumnClassName.equals("java.lang.Object") && sColumnTypeName.trim().equals("NULL")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                if (sColumnClassName.equals("java.lang.Object") && sColumnTypeName.trim().equals("TEXT")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                if (sColumnClassName.equals("java.lang.Object") && sColumnTypeName.trim().equals("NUMERIC")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                json.put((Object)key_name, rs.getObject(sColumnName));
                String value = null;
                if (rs.getObject(sColumnName) != null) {
                    value = rs.getObject(sColumnName).toString();
                }
                System.out.println("\u672a\u5b9a\u4e49\u7684jdbc\u7c7b\u578b\u6620\u5c04:ColumnName=" + sColumnName + ",ColumnClassName=" + sColumnClassName + ",ColumnTypeName=" + sColumnTypeName + ", value=" + value);
            }
            jsonArray.add((Object)json);
        }
        return jsonArray;
    }

    public static String clobToString(Clob clob) throws SQLException, IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        Reader reader = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static byte[] BlobToBytes(Blob blob) throws Exception {
        byte[] result = blob.getBytes(1L, 0xA00000);
        return result;
    }
}

