/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.cipher.sm;

import cn.liboss.ass.cipher.sm.ByteUtil;
import cn.liboss.ass.cipher.sm.SM4;
import cn.liboss.ass.cipher.sm.SM4_Context;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SM4Utils {
    private String secretKey = "";
    private boolean hexString = false;
    private String iv = "";
    private String ciphertextType = "hex";
    public static String key = "xxzx2023@GDMMRDC";
    public static String Iv = "GEGMMRDCxxzx2023";

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public boolean isHexString() {
        return this.hexString;
    }

    public void setHexString(boolean hexString) {
        this.hexString = hexString;
    }

    public String getIv() {
        return this.iv;
    }

    public void setIv(String iv) {
        this.iv = iv;
    }

    public String getCiphertextType() {
        return this.ciphertextType;
    }

    public void setCiphertextType(String ciphertextType) {
        this.ciphertextType = ciphertextType;
    }

    public String encryptData_ECB(String plainText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_ecb(ctx, plainText.getBytes("UTF-8"));
            String cipherText = "";
            cipherText = this.ciphertextType == "base64" ? Base64.getEncoder().encodeToString(encrypted) : ByteUtil.byteToHex(encrypted).toLowerCase();
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_ECB(String cipherText) {
        try {
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            byte[] keyBytes = this.hexString ? ByteUtil.hexStringToBytes(this.secretKey) : this.secretKey.getBytes();
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = null;
            decrypted = this.ciphertextType == "base64" ? sm4.sm4_crypt_ecb(ctx, Base64.getDecoder().decode(cipherText)) : sm4.sm4_crypt_ecb(ctx, ByteUtil.hexToByte(cipherText.toUpperCase()));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String encryptData_CBC(String plainText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 1;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_enc(ctx, keyBytes);
            byte[] encrypted = sm4.sm4_crypt_cbc(ctx, ivBytes, plainText.getBytes("UTF-8"));
            String cipherText = "";
            cipherText = this.ciphertextType == "base64" ? Base64.getEncoder().encodeToString(encrypted) : ByteUtil.byteToHex(encrypted).toLowerCase();
            if (cipherText != null && cipherText.trim().length() > 0) {
                Pattern p = Pattern.compile("\\s*|\t|\r|\n");
                Matcher m = p.matcher(cipherText);
                cipherText = m.replaceAll("");
            }
            return cipherText;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String decryptData_CBC(String cipherText) {
        try {
            byte[] ivBytes;
            byte[] keyBytes;
            SM4_Context ctx = new SM4_Context();
            ctx.isPadding = true;
            ctx.mode = 0;
            if (this.hexString) {
                keyBytes = ByteUtil.hexStringToBytes(this.secretKey);
                ivBytes = ByteUtil.hexStringToBytes(this.iv);
            } else {
                keyBytes = this.secretKey.getBytes();
                ivBytes = this.iv.getBytes();
            }
            SM4 sm4 = new SM4();
            sm4.sm4_setkey_dec(ctx, keyBytes);
            byte[] decrypted = null;
            decrypted = this.ciphertextType == "base64" ? sm4.sm4_crypt_cbc(ctx, ivBytes, Base64.getDecoder().decode(cipherText)) : sm4.sm4_crypt_cbc(ctx, ivBytes, ByteUtil.hexToByte(cipherText.toUpperCase()));
            return new String(decrypted, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String encryptMMPortal(String plainText) {
        SM4Utils sm4 = new SM4Utils();
        sm4.setSecretKey(key);
        sm4.setIv(Iv);
        String cipherText = sm4.encryptData_CBC(plainText);
        return cipherText;
    }

    public static String decryptMMPortal(String cipherText) {
        SM4Utils sm4 = new SM4Utils();
        sm4.setSecretKey(key);
        sm4.setIv(Iv);
        String rs = sm4.decryptData_CBC(cipherText);
        return rs;
    }
}

