/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SFTPUtils {
    private Logger log = LogManager.getLogger(this.getClass());
    private String host;
    private String username;
    private String password;
    private int port = 22;
    public ChannelSftp sftp = null;
    public Session sshSession = null;

    public SFTPUtils(String host, int port, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
        this.port = port;
    }

    public SFTPUtils(String host, String username, String password) {
        this.host = host;
        this.username = username;
        this.password = password;
    }

    public void connect() {
        try {
            this.sshSession = new JSch().getSession(this.username, this.host, this.port);
            this.sshSession.setPassword(this.password);
            Properties sshConfig = new Properties();
            sshConfig.put("StrictHostKeyChecking", "no");
            this.sshSession.setConfig(sshConfig);
            this.sshSession.connect();
            Channel channel = this.sshSession.openChannel("sftp");
            channel.connect();
            this.sftp = (ChannelSftp)channel;
            String info = String.format("sftp\u8fde\u63a5\u6210\u529f,%s:%d,%s", this.host, this.port, this.username, this.password);
            this.log.info(info);
        }
        catch (Exception e) {
            String info = String.format("sftp\u8fde\u63a5\u5931\u8d25,%s:%d,%s", this.host, this.port, this.username, this.password);
            this.log.info(info);
            e.printStackTrace();
        }
    }

    public void disconnect() {
        if (this.sftp != null && this.sftp.isConnected()) {
            this.sftp.disconnect();
        }
        if (this.sshSession != null && this.sshSession.isConnected()) {
            this.sshSession.disconnect();
        }
        if (this.log.isInfoEnabled()) {
            this.log.info("ChannelSftp and sshSession is closed already");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> batchDownLoadFile(String remotePath, String localPath, String fileFormat, String fileEndFormat, boolean del) {
        ArrayList<String> filenames = new ArrayList<String>();
        try {
            Vector v = this.listFiles(remotePath);
            if (v.size() > 0) {
                System.out.println("\u672c\u6b21\u5904\u7406\u6587\u4ef6\u4e2a\u6570\u4e0d\u4e3a\u96f6,\u5f00\u59cb\u4e0b\u8f7d...fileSize=" + v.size());
                for (ChannelSftp.LsEntry entry : v) {
                    String filename = entry.getFilename();
                    SftpATTRS attrs = entry.getAttrs();
                    if (attrs.isDir()) continue;
                    boolean flag = false;
                    String localFileName = localPath + filename;
                    fileFormat = fileFormat == null ? "" : fileFormat.trim();
                    String string = fileEndFormat = fileEndFormat == null ? "" : fileEndFormat.trim();
                    if (fileFormat.length() > 0 && fileEndFormat.length() > 0) {
                        if (!filename.startsWith(fileFormat) || !filename.endsWith(fileEndFormat) || !(flag = this.downloadFile(remotePath, filename, localPath, filename))) continue;
                        filenames.add(localFileName);
                        if (!flag || !del) continue;
                        this.deleteSFTP(remotePath + filename);
                        continue;
                    }
                    if (fileFormat.length() > 0 && "".equals(fileEndFormat)) {
                        if (!filename.startsWith(fileFormat) || !(flag = this.downloadFile(remotePath, filename, localPath, filename))) continue;
                        filenames.add(localFileName);
                        if (!flag || !del) continue;
                        this.deleteSFTP(remotePath + filename);
                        continue;
                    }
                    if (fileEndFormat.length() > 0 && "".equals(fileFormat)) {
                        if (!filename.endsWith(fileEndFormat) || !(flag = this.downloadFile(remotePath, filename, localPath, filename))) continue;
                        filenames.add(localFileName);
                        if (!flag || !del) continue;
                        this.deleteSFTP(remotePath + filename);
                        continue;
                    }
                    flag = this.downloadFile(remotePath, filename, localPath, filename);
                    if (!flag) continue;
                    filenames.add(localFileName);
                    if (!flag || !del) continue;
                    this.deleteSFTP(remotePath + filename);
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("download file is success:remotePath=" + remotePath + "and localPath=" + localPath + ",file size is" + v.size());
            }
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        return filenames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downloadFile(String remotePath, String remoteFileName, String localPath, String localFileName) {
        FileOutputStream fieloutput = null;
        try {
            File file = new File(localPath + localFileName);
            fieloutput = new FileOutputStream(file);
            this.sftp.get(remotePath + "/" + remoteFileName, (OutputStream)fieloutput);
            boolean bl = true;
            return bl;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SftpException e) {
            e.printStackTrace();
        }
        finally {
            if (null != fieloutput) {
                try {
                    fieloutput.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFileToFolder(String localFile, String remotePath) throws Exception {
        FileInputStream in = null;
        try {
            this.createDir(remotePath);
            File file = new File(localFile);
            in = new FileInputStream(file);
            this.sftp.cd(remotePath);
            this.sftp.put((InputStream)in, file.getName().toUpperCase());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bacthUploadFile(String remotePath, String localPath, boolean del) {
        try {
            this.connect();
            File localDir = new File(localPath);
            File[] files = localDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].isFile() || files[i].getName().indexOf("bak") != -1) continue;
                this.uploadFileToFolder(files[i].getAbsolutePath(), remotePath);
                if (!del) continue;
                this.deleteFile(localPath + File.separator + files[i].getName());
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("upload file is success:remotePath=" + remotePath + "and localPath=" + localPath + ",file size is " + files.length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.disconnect();
        }
    }

    public boolean deleteFile(String filePath) {
        File file = new File(filePath);
        if (!file.exists()) {
            return false;
        }
        if (!file.isFile()) {
            return false;
        }
        boolean rs = file.delete();
        if (rs && this.log.isInfoEnabled()) {
            this.log.info("delete file success from local.");
        }
        return rs;
    }

    public boolean createDir(String createpath) {
        try {
            if (this.isDirExist(createpath)) {
                this.sftp.cd(createpath);
                return true;
            }
            String[] pathArry = createpath.split("/");
            StringBuffer filePath = new StringBuffer("/");
            for (String path : pathArry) {
                if (path.equals("")) continue;
                filePath.append(path + "/");
                if (this.isDirExist(filePath.toString())) {
                    this.sftp.cd(filePath.toString());
                    continue;
                }
                this.sftp.mkdir(filePath.toString());
                this.sftp.cd(filePath.toString());
            }
            this.sftp.cd(createpath);
            return true;
        }
        catch (SftpException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean isDirExist(String directory) {
        boolean isDirExistFlag = false;
        try {
            SftpATTRS sftpATTRS = this.sftp.lstat(directory);
            isDirExistFlag = true;
            return sftpATTRS.isDir();
        }
        catch (Exception e) {
            if (e.getMessage().toLowerCase().equals("no such file")) {
                isDirExistFlag = false;
            }
            return isDirExistFlag;
        }
    }

    public void deleteSFTP(String sftpPathFile) throws SftpException {
        this.sftp.rm(sftpPathFile);
    }

    public void mkdirs(String path) {
        File f = new File(path);
        String fs = f.getParent();
        if (!(f = new File(fs)).exists()) {
            f.mkdirs();
        }
    }

    public Vector listFiles(String directory) throws SftpException {
        return this.sftp.ls(directory);
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public ChannelSftp getSftp() {
        return this.sftp;
    }

    public void setSftp(ChannelSftp sftp) {
        this.sftp = sftp;
    }

    public InputStream getInputStream(String sftp_file_path) throws Exception {
        InputStream is = this.sftp.get(sftp_file_path);
        return is;
    }
}

