/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.poi;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class PoiExcelUtil {
    public static void main(String[] args) throws Exception {
        String s1 = "C:\\Users\\lam99\\Desktop\\\u6e2f\u53e3-SOE\u6837\u672c.xlsx";
        List<List<Object>> list1 = PoiExcelUtil.readExcelFile(s1, "", 2);
        System.out.println(list1);
    }

    public static Workbook initWorkbook(String file_name) throws Exception {
        HSSFWorkbook wb = null;
        try (FileInputStream fis = new FileInputStream(file_name);){
            if (file_name.endsWith(".xls")) {
                wb = new HSSFWorkbook((InputStream)fis);
            } else if (file_name.endsWith(".xlsx")) {
                wb = new XSSFWorkbook((InputStream)fis);
            } else {
                System.out.println(file_name + "\u4e0d\u662f\u53ef\u4ee5\u88ab\u672c\u7c7b\u89e3\u6790\u7684\u6587\u4ef6");
            }
        }
        return wb;
    }

    public static List<List<Object>> readExcelFile(String file_name, String sheet_name, int dataBeginRowIndex) throws Exception {
        Workbook workbook = PoiExcelUtil.initWorkbook(file_name);
        Sheet sheet = null;
        sheet = sheet_name != null && !sheet_name.equals("") ? workbook.getSheet(sheet_name) : workbook.getSheetAt(0);
        List<List<Object>> tableRowsData = PoiExcelUtil.readExcelFileToList(workbook, sheet, dataBeginRowIndex);
        workbook.close();
        return tableRowsData;
    }

    public static List<List<Object>> readExcelFile(String file_name, int sheet_index, int dataBeginRowIndex) throws Exception {
        Workbook workbook = PoiExcelUtil.initWorkbook(file_name);
        Sheet sheet = workbook.getSheetAt(sheet_index);
        List<List<Object>> tableRowsData = PoiExcelUtil.readExcelFileToList(workbook, sheet, dataBeginRowIndex);
        workbook.close();
        return tableRowsData;
    }

    private static List<List<Object>> readExcelFileToList(Workbook workbook, Sheet sheet, int dataBeginRowIndex) throws Exception {
        ArrayList<List<Object>> tableRowsData = new ArrayList<List<Object>>();
        int rowsSize = sheet.getPhysicalNumberOfRows();
        for (int i = dataBeginRowIndex; i < rowsSize; ++i) {
            Row row = sheet.getRow(i);
            ArrayList<String> rowData = new ArrayList<String>();
            for (int j = 0; j < row.getPhysicalNumberOfCells(); ++j) {
                String value1 = PoiExcelUtil.getCellFormatValue(row.getCell(j));
                rowData.add(value1);
            }
            tableRowsData.add(rowData);
        }
        return tableRowsData;
    }

    private static String getCellFormatValue(Cell cell) {
        String cellValue = "";
        if (cell != null) {
            switch (cell.getCellType()) {
                case FORMULA: {
                    cellValue = "" + cell.getCellFormula();
                    break;
                }
                case NUMERIC: {
                    cellValue = String.valueOf(cell.getNumericCellValue());
                    break;
                }
                case STRING: {
                    cellValue = cell.getStringCellValue();
                    break;
                }
                case BLANK: {
                    cellValue = "<BLANK>";
                    break;
                }
                case BOOLEAN: {
                    cellValue = "" + cell.getBooleanCellValue();
                    break;
                }
                case ERROR: {
                    cellValue = "" + cell.getErrorCellValue();
                    break;
                }
                default: {
                    cellValue = "" + cell.getCellType();
                }
            }
        }
        return cellValue;
    }

    public static void copyCellStyle(Workbook workbook, CellStyle fromStyle, CellStyle toStyle) {
        HSSFCellStyle style;
        toStyle.setAlignment(fromStyle.getAlignment());
        toStyle.setVerticalAlignment(fromStyle.getVerticalAlignment());
        toStyle.setBorderBottom(fromStyle.getBorderBottom());
        toStyle.setBorderLeft(fromStyle.getBorderLeft());
        toStyle.setBorderRight(fromStyle.getBorderRight());
        toStyle.setBorderTop(fromStyle.getBorderTop());
        toStyle.setTopBorderColor(fromStyle.getTopBorderColor());
        toStyle.setBottomBorderColor(fromStyle.getBottomBorderColor());
        toStyle.setRightBorderColor(fromStyle.getRightBorderColor());
        toStyle.setLeftBorderColor(fromStyle.getLeftBorderColor());
        if (fromStyle instanceof XSSFCellStyle) {
            XSSFCellStyle xssfToStyle = (XSSFCellStyle)toStyle;
            xssfToStyle.setFillBackgroundColor(((XSSFCellStyle)fromStyle).getFillBackgroundColorColor());
            xssfToStyle.setFillForegroundColor(((XSSFCellStyle)fromStyle).getFillForegroundColorColor());
        } else {
            toStyle.setFillBackgroundColor(fromStyle.getFillBackgroundColor());
            toStyle.setFillForegroundColor(fromStyle.getFillForegroundColor());
        }
        toStyle.setDataFormat(fromStyle.getDataFormat());
        toStyle.setFillPattern(fromStyle.getFillPattern());
        if (fromStyle instanceof HSSFCellStyle) {
            style = (HSSFCellStyle)fromStyle;
            toStyle.setFont((Font)style.getFont(workbook));
        } else if (fromStyle instanceof XSSFCellStyle) {
            style = (XSSFCellStyle)fromStyle;
            toStyle.setFont((Font)style.getFont());
        }
        toStyle.setHidden(fromStyle.getHidden());
        toStyle.setIndention(fromStyle.getIndention());
        toStyle.setLocked(fromStyle.getLocked());
        toStyle.setRotation(fromStyle.getRotation());
        toStyle.setWrapText(fromStyle.getWrapText());
    }
}

