/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.http;

import cn.liboss.ass.core.StringUtil;
import cn.liboss.ass.http.HttpHeader;
import cn.liboss.ass.http.MyX509TrustManager;
import cn.liboss.ass.http.ResponseResult;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;

public class SimpleHttpClient {
    private static final String KEY_HEADER_COOKIE = "Set-Cookie";
    private static final String KEY_REQUEST_COOKIE = "Cookie";
    public static final String CHARSET_NAME_UTF_8 = "UTF-8";
    public static final String CHARSET_NAME_GBK = "GBK";
    private static String REQUEST_METHOD_GET = "GET";
    private static String REQUEST_METHOD_POST = "POST";
    private static String REQUEST_METHOD_PUT = "PUT";
    private static String REQUEST_METHOD_DELETE = "DELETE";
    public static int ConnectTimeout = 10000;
    public static int ReadTimeout = 60000;
    public static String Content_Type_urlencoded = "application/x-www-form-urlencoded";
    public static String Content_Type_form = "multipart/form-data";
    public static String Content_Type_json = "application/json";
    public static String Content_Type_xml = "text/xml";

    private static HttpURLConnection createHttpURLConnection(String httpsURL, String REQUEST_METHOD, Map<String, String> headers, String cookiesText, Proxy proxy) throws Exception {
        SSLContext sslcontext = SSLContext.getInstance("SSL", "SunJSSE");
        sslcontext.init(null, new TrustManager[]{new MyX509TrustManager()}, new SecureRandom());
        HostnameVerifier ignoreHostnameVerifier = new HostnameVerifier(){

            @Override
            public boolean verify(String s, SSLSession sslsession) {
                return true;
            }
        };
        HttpsURLConnection.setDefaultHostnameVerifier(ignoreHostnameVerifier);
        HttpsURLConnection.setDefaultSSLSocketFactory(sslcontext.getSocketFactory());
        URL url = new URL(httpsURL);
        HttpURLConnection connection = null;
        connection = proxy != null ? (HttpURLConnection)url.openConnection(proxy) : (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(REQUEST_METHOD);
        connection.setConnectTimeout(ConnectTimeout);
        connection.setReadTimeout(ReadTimeout);
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setUseCaches(false);
        if (headers != null) {
            Set<Map.Entry<String, String>> entrySet = headers.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                String key = entry.getKey();
                String value = entry.getValue();
                connection.setRequestProperty(key, value);
            }
        }
        if (cookiesText != null && cookiesText != "") {
            connection.setRequestProperty(KEY_REQUEST_COOKIE, cookiesText);
        }
        return connection;
    }

    private static ResponseResult toResponseResult(HttpURLConnection connection, CookieManager cookieManager, String charsetName) throws Exception {
        ResponseResult result = new ResponseResult();
        result.setResponseCode(connection.getResponseCode());
        if (connection.getResponseMessage() != null) {
            result.setResponseMessage(connection.getResponseMessage());
        }
        List<String> cookieHeaderList = connection.getHeaderFields().get(KEY_HEADER_COOKIE);
        result.setCookieHeaderList(cookieHeaderList);
        CookieStore cookieStore = cookieManager.getCookieStore();
        List<HttpCookie> cookies = cookieStore.getCookies();
        result.setHttpCookiesList(cookies);
        StringBuffer cookieText = new StringBuffer();
        if (cookieHeaderList != null && cookieHeaderList.size() > 0) {
            for (String string : cookieHeaderList) {
                if (string.length() <= 0) continue;
                cookieText.append(string).append(";");
            }
        }
        for (HttpCookie cook1 : cookies) {
            cookieText.append(cook1).append(";");
        }
        result.setCookies(cookieText.toString());
        InputStream input = null;
        input = connection.getResponseCode() >= 200 && connection.getResponseCode() < 300 ? connection.getInputStream() : connection.getErrorStream();
        if (input != null) {
            BufferedReader br = null;
            br = new BufferedReader(new InputStreamReader(input, charsetName));
            StringBuffer sbf = new StringBuffer();
            String temp = null;
            while ((temp = br.readLine()) != null) {
                sbf.append(temp);
                sbf.append("\n");
            }
            result.setResponseData(sbf.toString());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseResult get(String httpUrl, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedReader br = null;
        ResponseResult result = new ResponseResult();
        try {
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cookieManager);
            connection = SimpleHttpClient.createHttpURLConnection(httpUrl, REQUEST_METHOD_GET, headers, cookiesText, proxy);
            connection.connect();
            result = SimpleHttpClient.toResponseResult(connection, cookieManager, charsetName);
        }
        catch (Exception ex) {
            try {
                result.setResponseMessage(ex.getMessage());
                result.setResponseData(StringUtil.exceptionToString(ex));
            }
            catch (Throwable throwable) {
                SimpleHttpClient.close(br, null, is, connection);
                throw throwable;
            }
            SimpleHttpClient.close(br, null, is, connection);
        }
        SimpleHttpClient.close(br, null, is, connection);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResponseResult postUrlEncoded(String httpUrl, JSONObject param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        HttpURLConnection connection = null;
        InputStream input = null;
        OutputStream output = null;
        BufferedReader br = null;
        ResponseResult result = new ResponseResult();
        try {
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cookieManager);
            connection = SimpleHttpClient.createHttpURLConnection(httpUrl, REQUEST_METHOD_POST, headers, cookiesText, proxy);
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded;charset=utf-8");
            connection.setRequestProperty("Accept", "application/html");
            connection.connect();
            output = connection.getOutputStream();
            StringBuffer paramString = new StringBuffer();
            if (param != null && param.size() > 0) {
                for (Map.Entry entry : param.entrySet()) {
                    paramString.append(URLEncoder.encode((String)entry.getKey(), "utf-8") + "=" + URLEncoder.encode(entry.getValue().toString(), "utf-8") + "&");
                }
                if (paramString.length() > 0) {
                    paramString = paramString.deleteCharAt(paramString.length() - 1);
                }
                output.write(paramString.toString().getBytes());
            }
            result = SimpleHttpClient.toResponseResult(connection, cookieManager, charsetName);
        }
        catch (Exception ex) {
            try {
                result.setResponseMessage(ex.getMessage());
                result.setResponseData(StringUtil.exceptionToString(ex));
            }
            catch (Throwable throwable) {
                SimpleHttpClient.close(br, output, input, connection);
                throw throwable;
            }
            SimpleHttpClient.close(br, output, input, connection);
        }
        SimpleHttpClient.close(br, output, input, connection);
        return result;
    }

    public static ResponseResult postByJson(String httpUrl, JSONObject param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        return SimpleHttpClient.post_put_deleteJson(httpUrl, param.toJSONString(new JSONWriter.Feature[0]), charsetName, headers, cookiesText, proxy, REQUEST_METHOD_POST);
    }

    public static ResponseResult putByJson(String httpUrl, JSONObject param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        return SimpleHttpClient.post_put_deleteJson(httpUrl, param.toJSONString(new JSONWriter.Feature[0]), charsetName, headers, cookiesText, proxy, REQUEST_METHOD_PUT);
    }

    public static ResponseResult deleteByJson(String httpUrl, JSONObject param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        return SimpleHttpClient.post_put_deleteJson(httpUrl, param.toJSONString(new JSONWriter.Feature[0]), charsetName, headers, cookiesText, proxy, REQUEST_METHOD_DELETE);
    }

    public static ResponseResult postByJson(String httpUrl, String param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        return SimpleHttpClient.post_put_deleteJson(httpUrl, param, charsetName, headers, cookiesText, proxy, REQUEST_METHOD_POST);
    }

    public static ResponseResult putByJson(String httpUrl, String param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        return SimpleHttpClient.post_put_deleteJson(httpUrl, param, charsetName, headers, cookiesText, proxy, REQUEST_METHOD_PUT);
    }

    public static ResponseResult deleteByJson(String httpUrl, String param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy) {
        return SimpleHttpClient.post_put_deleteJson(httpUrl, param, charsetName, headers, cookiesText, proxy, REQUEST_METHOD_DELETE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ResponseResult post_put_deleteJson(String httpUrl, String param, String charsetName, Map<String, String> headers, String cookiesText, Proxy proxy, String REQUEST_METHOD) {
        HttpURLConnection connection = null;
        InputStream input = null;
        OutputStream output = null;
        BufferedReader br = null;
        ResponseResult result = new ResponseResult();
        try {
            CookieManager cookieManager = new CookieManager();
            cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
            CookieHandler.setDefault(cookieManager);
            connection = SimpleHttpClient.createHttpURLConnection(httpUrl, REQUEST_METHOD, headers, cookiesText, proxy);
            connection.setRequestProperty("Content-Type", "application/json;charset=utf-8");
            connection.setRequestProperty("Accept", "application/json");
            connection.connect();
            output = connection.getOutputStream();
            if (param != null && param.length() > 0) {
                output.write(param.getBytes());
            }
            result = SimpleHttpClient.toResponseResult(connection, cookieManager, charsetName);
        }
        catch (Exception ex) {
            try {
                result.setResponseMessage(ex.getMessage());
                result.setResponseData(StringUtil.exceptionToString(ex));
            }
            catch (Throwable throwable) {
                SimpleHttpClient.close(br, output, input, connection);
                throw throwable;
            }
            SimpleHttpClient.close(br, output, input, connection);
        }
        SimpleHttpClient.close(br, output, input, connection);
        return result;
    }

    private static void close(BufferedReader br, OutputStream os, InputStream is, HttpURLConnection connection) {
        if (null != br) {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != os) {
            try {
                os.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (null != is) {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            connection.disconnect();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static byte[] getUrlFileBytes(String httpUrl, Map<String, String> headers, String cookiesText, Proxy proxy) throws Exception {
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            byte[] bytes;
            connection = SimpleHttpClient.createHttpURLConnection(httpUrl, REQUEST_METHOD_GET, headers, cookiesText, proxy);
            is = connection.getInputStream();
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            int size = 1024;
            byte[] buff = new byte[size];
            int rc = 0;
            while ((rc = is.read(buff, 0, size)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] byArray = bytes = swapStream.toByteArray();
            return byArray;
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            try {
                connection.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public static void downFile(String httpUrl, String outputFile, Map<String, String> headers, String cookiesText, Proxy proxy) throws Exception {
        HttpURLConnection connection = null;
        InputStream is = null;
        try {
            connection = SimpleHttpClient.createHttpURLConnection(httpUrl, REQUEST_METHOD_GET, headers, cookiesText, proxy);
            is = connection.getInputStream();
            ByteArrayOutputStream swapStream = new ByteArrayOutputStream();
            int size = 1024;
            byte[] buff = new byte[size];
            int rc = 0;
            while ((rc = is.read(buff, 0, size)) > 0) {
                swapStream.write(buff, 0, rc);
            }
            byte[] bytes = swapStream.toByteArray();
            File file = new File(outputFile);
            FileOutputStream os = new FileOutputStream(file);
            os.write(bytes);
            os.close();
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            try {
                connection.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadFile(String fileName, String Url, String strSiteID, String strColumnID, String strDespatcher, String strMechanism, String strOther1) {
        try {
            String fname = fileName;
            File file = new File(fname);
            URL url = new URL(Url);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setChunkedStreamingMode(0x100000);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("connection", "Keep-Alive");
            conn.setRequestProperty("Charsert", CHARSET_NAME_UTF_8);
            conn.setConnectTimeout(600000);
            conn.setRequestProperty("Content-Type", "multipart/form-data;file=" + file.getName());
            conn.setRequestProperty("fileName", file.getName());
            conn.setRequestProperty("strSiteID", strSiteID);
            conn.setRequestProperty("strColumnID", strColumnID);
            conn.setRequestProperty("strDespatcher", strDespatcher);
            conn.setRequestProperty("strMechanism", strMechanism);
            conn.setRequestProperty("strOther1", strOther1);
            conn.connect();
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            DataInputStream in = new DataInputStream(new FileInputStream(file));
            int bytes = 0;
            byte[] bufferOut = new byte[2048];
            while ((bytes = in.read(bufferOut)) != -1) {
                ((OutputStream)out).write(bufferOut, 0, bytes);
            }
            in.close();
            ((OutputStream)out).flush();
            ((OutputStream)out).close();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            String line = null;
            while ((line = reader.readLine()) != null) {
                System.out.println("---line---" + line);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            new File(fileName).delete();
        }
    }

    private static CookieStore getCookieStore() {
        CookieManager manager = new CookieManager();
        manager.setCookiePolicy(CookiePolicy.ACCEPT_ORIGINAL_SERVER);
        CookieHandler.setDefault(manager);
        CookieStore cookieStore = manager.getCookieStore();
        return cookieStore;
    }

    public static String getBasicAuth(String authUsername, String authPassword) {
        String userAndPwd = authUsername + ":" + authPassword;
        byte[] rel = Base64.getEncoder().encode(userAndPwd.getBytes());
        String auth = "Basic " + new String(rel);
        return auth;
    }

    public static ResponseResult demoAddUser(JSONObject json) {
        String url = "http://localhost:8080/activiti-rest/service/identity/users";
        Map<String, String> headers = HttpHeader.getPCHttpHeader();
        ResponseResult result = SimpleHttpClient.postByJson(url, json, "utf8", headers, null, null);
        return result;
    }
}

