/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.dao;

import cn.liboss.ass.dao.EntityMetaData;
import cn.liboss.ass.dao.annotation.EntityInfo;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.poi.ss.formula.functions.T;

public class EntityCache {
    private static HashMap<String, EntityMetaData> mataDataMap = new HashMap();

    public static EntityMetaData getEntityMetaData(Class entityObjectClass) throws RuntimeException {
        EntityMetaData metaData1 = mataDataMap.get(entityObjectClass.getName());
        if (metaData1 == null) {
            System.out.println("EntityCache_init:" + entityObjectClass.getName());
            metaData1 = EntityCache.BuildMetaData(entityObjectClass);
            metaData1.SQLInsert = EntityCache.BuildSQLTemplateInsert(metaData1);
            metaData1.SQLUpdate = EntityCache.BuildSQLTemplateUpdate(metaData1);
            metaData1.SQLDelete = EntityCache.BuildSQLTemplateDelete(metaData1);
            metaData1.SQLSelect = EntityCache.BuildSQLTemplateSelect(metaData1);
            mataDataMap.put(entityObjectClass.getName(), metaData1);
        }
        return metaData1;
    }

    private static EntityMetaData BuildMetaData(Class<T> entityObjectClass) throws RuntimeException {
        int i;
        EntityMetaData metaData1 = new EntityMetaData();
        EntityInfo annot_Entity = entityObjectClass.getAnnotation(EntityInfo.class);
        metaData1.TableName = annot_Entity.tableName();
        metaData1.PKFiledName = annot_Entity.pkFiledName();
        try {
            Method[] arrMethod = entityObjectClass.getDeclaredMethods();
            for (i = 0; i < arrMethod.length; ++i) {
                Method m1 = entityObjectClass.getMethod(arrMethod[i].getName(), arrMethod[i].getParameterTypes());
                metaData1.MethodHashMap.put(arrMethod[i].getName(), m1);
                if (arrMethod[i].getName().substring(0, 3).equals("set")) {
                    metaData1.SetMethodArray.add(m1);
                    metaData1.SetMethodHashMap.put(arrMethod[i].getName(), m1);
                    continue;
                }
                if (!arrMethod[i].getName().substring(0, 3).equals("get")) continue;
                metaData1.GetMethodArray.add(m1);
                metaData1.GetMethodHashMap.put(arrMethod[i].getName(), m1);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        Field[] arrField = entityObjectClass.getFields();
        for (i = 0; i < arrField.length; ++i) {
            metaData1.FieldArray.put(arrField[i].getName(), arrField[i]);
        }
        return metaData1;
    }

    private static String BuildSQLTemplateInsert(EntityMetaData metaData) {
        ArrayList<Method> arrMethod = metaData.GetMethodArray;
        StringBuilder sql_sub1 = new StringBuilder();
        StringBuilder sql_sub2 = new StringBuilder();
        for (int i = 0; i < arrMethod.size(); ++i) {
            Method curMethod = arrMethod.get(i);
            String sFieldName = curMethod.getName().substring(3);
            sql_sub1.append(sFieldName + ",");
            sql_sub2.append("?,");
        }
        sql_sub1.deleteCharAt(sql_sub1.length() - 1);
        sql_sub2.deleteCharAt(sql_sub2.length() - 1);
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Insert into ").append(metaData.TableName).append(" ");
        sSQL.append(" (").append(sql_sub1.toString()).append(") ");
        sSQL.append(" Values (").append(sql_sub2.toString()).append(") ");
        String sql = sSQL.toString();
        return sql;
    }

    private static String BuildSQLTemplateUpdate(EntityMetaData metaData) {
        ArrayList<Method> arrMethod = metaData.GetMethodArray;
        StringBuilder sql_sub1 = new StringBuilder();
        for (int i = 0; i < arrMethod.size(); ++i) {
            Method curMethod = arrMethod.get(i);
            String sFieldName = curMethod.getName().substring(3);
            if (sFieldName.toLowerCase().equals(metaData.PKFiledName)) continue;
            sql_sub1.append(sFieldName + "=?,");
        }
        sql_sub1.deleteCharAt(sql_sub1.length() - 1);
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Update ").append(metaData.TableName).append(" ");
        sSQL.append(" Set ").append(sql_sub1.toString()).append(" ");
        sSQL.append(" Where ").append(metaData.PKFiledName).append("=? ");
        String sql = sSQL.toString();
        return sql;
    }

    private static String BuildSQLTemplateDelete(EntityMetaData metaData) {
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Delete From ").append(metaData.TableName);
        String sql = sSQL.toString();
        return sql;
    }

    private static String BuildSQLTemplateSelect(EntityMetaData metaData) {
        ArrayList<Method> arrMethod = metaData.GetMethodArray;
        StringBuilder sql_sub1 = new StringBuilder();
        for (int i = 0; i < arrMethod.size(); ++i) {
            Method curMethod = arrMethod.get(i);
            String sFieldName = curMethod.getName().substring(3);
            if (sFieldName.toLowerCase().equals(metaData.PKFiledName)) continue;
            sql_sub1.append(sFieldName + ",");
        }
        sql_sub1.deleteCharAt(sql_sub1.length() - 1);
        StringBuilder sSQL = new StringBuilder();
        sSQL.append("Select ").append(sql_sub1.toString()).append(" ");
        sSQL.append(" From ").append(metaData.TableName);
        String sql = sSQL.toString();
        return sql;
    }
}

