/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.dao;

import cn.liboss.ass.core.JdbcHelper;
import cn.liboss.ass.core.JsonUtil;
import cn.liboss.ass.core.StringUtil;
import cn.liboss.ass.dao.BuildExecSQL;
import cn.liboss.ass.dao.PageInfo;
import cn.liboss.ass.dao.fieldmap.DBTransform;
import cn.liboss.ass.dao.fieldmap.MySQL;
import cn.liboss.ass.dao.fieldmap.Oracle;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.ss.formula.functions.T;

public class DBSession {
    Logger logger = LogManager.getLogger((Object)this);
    private DataSource dataSource;
    private String DBType = "mysql";
    public BuildExecSQL build = new BuildExecSQL();

    public DBTransform getDBTransform() {
        if (this.getDBType().equals("mysql")) {
            return new MySQL();
        }
        if (this.getDBType().equals("oracle")) {
            return new Oracle();
        }
        return null;
    }

    public DBSession(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }

    public String getDBType() {
        return this.DBType;
    }

    public synchronized int getIntPkId(String table_name) {
        table_name = table_name.toLowerCase();
        int pkid = 0;
        String updateSQL = "update assist_pk_info set pk_value=pk_value+1 where table_name='" + StringUtil.sqlFilter(table_name) + "'";
        int rows = this.executeUpdate(updateSQL);
        if (rows > 0) {
            String sql = "select pk_value from assist_pk_info where table_name='" + StringUtil.sqlFilter(table_name) + "'";
            JSONArray array = this.query(sql);
            pkid = array.getJSONObject(0).getIntValue("pk_value");
        } else {
            String insertSQL = "insert into assist_pk_info(table_name,pk_value) values ('" + StringUtil.sqlFilter(table_name) + "',1) ";
            this.executeUpdate(insertSQL);
            pkid = 1;
        }
        return pkid;
    }

    private void closeStatement(Statement statement) {
        try {
            if (statement != null) {
                statement.getConnection().close();
                statement.close();
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
    }

    public void executeUpdate(String sql, ArrayList<T> pramValues) {
        PreparedStatement objPreState = null;
        try {
            objPreState = this.getConnection().prepareStatement(sql);
            if (pramValues != null) {
                for (int i = 0; i < pramValues.size(); ++i) {
                    objPreState.setObject(i + 1, pramValues.get(i));
                }
            }
            if (pramValues == null) {
                // empty if block
            }
            objPreState.executeUpdate();
        }
        catch (Exception ex) {
            if (pramValues == null) {
                this.logger.error("SQL_Error : " + sql);
            } else {
                this.logger.error("SQL_Error : " + sql + pramValues.toArray());
            }
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objPreState);
        }
    }

    public void executeUpdateBatch(String sql, List<ArrayList> pramValuesArray) throws Exception {
        PreparedStatement objPreState = null;
        try {
            objPreState = this.getConnection().prepareStatement(sql);
            for (int m = 0; m < pramValuesArray.size(); ++m) {
                List prams = pramValuesArray.get(m);
                if (prams == null) {
                    this.logger.debug(sql);
                } else {
                    this.logger.debug(sql + prams.toString());
                }
                if (prams != null) {
                    for (int i = 0; i < prams.size(); ++i) {
                        objPreState.setObject(i + 1, prams.get(i));
                    }
                }
                objPreState.addBatch();
            }
            objPreState.executeBatch();
        }
        catch (SQLException ex) {
            if (pramValuesArray == null) {
                this.logger.error("SQL_Error : " + sql);
            } else {
                this.logger.error("SQL_Error : " + sql + "\n parmsArray.size=" + pramValuesArray.size());
            }
            throw ex;
        }
        finally {
            this.closeStatement(objPreState);
        }
    }

    public void executeUpdateByPrams(List<String> sqlArray, List<ArrayList<Object>> pramsArray) throws Exception {
        PreparedStatement objPreState = null;
        try {
            for (int i = 0; i < sqlArray.size(); ++i) {
                String sql = sqlArray.get(i);
                objPreState = this.getConnection().prepareStatement(sql);
                ArrayList<Object> prams = pramsArray.get(i);
                int m = 0;
                while (i < prams.size()) {
                    objPreState.setObject(m + 1, prams.get(m));
                    ++m;
                }
                objPreState.addBatch();
                objPreState.executeBatch();
            }
        }
        catch (Exception ex) {
            StringBuffer msg = new StringBuffer();
            StringBuffer sql = new StringBuffer();
            if (sqlArray.size() > 0) {
                for (int i = 0; i < sqlArray.size(); ++i) {
                    sql.append(sqlArray.get(i) + "\n");
                }
                msg.append("SQL_Error : \n" + sql.toString() + "\n");
            }
            msg = new StringBuffer(ex.toString() + "\r\n");
            throw new Exception(msg.toString(), ex);
        }
        finally {
            this.closeStatement(objPreState);
        }
    }

    public int executeUpdate(String sql) {
        Statement objState = null;
        int count = 0;
        try {
            objState = this.getConnection().createStatement();
            this.logger.debug("SQL_Debug : " + sql);
            count = objState.executeUpdate(sql);
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objState);
        }
        return count;
    }

    public void executeUpdate(List<String> sqlArray) {
        Statement objState = null;
        String sql = "";
        try {
            objState = this.getConnection().createStatement();
            for (int i = 0; i < sqlArray.size(); ++i) {
                sql = sqlArray.get(i);
                this.logger.debug(sql);
                objState.executeUpdate(sql);
            }
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objState);
        }
    }

    public ResultSet getResultSetByPrams(String sql, ArrayList<Object> prams) {
        PreparedStatement objPreState = null;
        try {
            ResultSet objRS;
            objPreState = this.getConnection().prepareStatement(sql);
            for (int i = 0; i < prams.size(); ++i) {
                objPreState.setObject(i, prams.get(i));
            }
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet resultSet = objRS = objPreState.executeQuery(sql);
            return resultSet;
        }
        catch (Exception ex) {
            if (prams == null) {
                this.logger.error("SQL_Error : " + sql);
            } else {
                this.logger.error("SQL_Error : " + sql + prams);
            }
            throw new RuntimeException(ex);
        }
    }

    public ResultSet getResultSet(String sql) {
        Statement objState = null;
        try {
            ResultSet objRS;
            objState = this.getConnection().createStatement();
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet resultSet = objRS = objState.executeQuery(sql);
            return resultSet;
        }
        catch (Exception ex) {
            this.logger.debug("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public ResultSetMetaData getMataData(String tableName) {
        String sql = "select * from " + tableName + " where 1=2";
        Statement objState = null;
        try {
            ResultSetMetaData md;
            objState = this.getConnection().createStatement();
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet rs = objState.executeQuery(sql);
            ResultSetMetaData resultSetMetaData = md = rs.getMetaData();
            return resultSetMetaData;
        }
        catch (Exception ex) {
            this.logger.debug("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
    }

    public JSONArray query(String sql) {
        JSONArray jsonArray;
        Statement objState = null;
        try {
            objState = this.getConnection().createStatement();
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet rs = objState.executeQuery(sql);
            jsonArray = JdbcHelper.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql);
            this.logger.error((Object)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objState);
        }
        return jsonArray;
    }

    public JSONArray queryAll(String tableOrViewOrSQLView, String whereString, String orderBy) {
        String sql = "Select * From " + tableOrViewOrSQLView;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString;
        }
        if (orderBy.trim().length() > 0) {
            sql = sql + " Order by " + orderBy;
        }
        return this.query(sql);
    }

    public List<HashMap<String, Object>> queryAllToMap(String tableOrViewOrSQLView, String whereString, String orderBy) {
        String sql = "Select * From " + tableOrViewOrSQLView;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString;
        }
        if (orderBy.trim().length() > 0) {
            sql = sql + " Order by " + orderBy;
        }
        List<HashMap<String, Object>> list = null;
        Statement objState = null;
        try {
            objState = this.getConnection().createStatement();
            this.logger.debug(sql);
            ResultSet rs = objState.executeQuery(sql);
            list = this.resultSetToMapList(rs);
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objState);
        }
        return list;
    }

    public JSONObject getOneJson(String tableOrViewName, String whereString) {
        String sql = "Select * From " + tableOrViewName;
        sql = sql + " Where " + whereString.trim();
        JSONArray jsonArray = this.query(sql);
        JSONObject json = null;
        if (jsonArray.size() > 0) {
            json = jsonArray.getJSONObject(0);
        }
        return json;
    }

    public T getOneEntity(String tableOrViewName, String whereString, Class<T> classEntity) {
        JSONObject json = this.getOneJson(tableOrViewName, whereString);
        T entity = null;
        if (json != null) {
            entity = JsonUtil.castJSONStringToEntity(json.toJSONString(new JSONWriter.Feature[0]), classEntity);
        }
        return entity;
    }

    public int getRowCount(String tableOrViewName, String whereString) {
        String sql = "Select count(1) as ROWCOUNT From " + tableOrViewName;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString.trim();
        }
        int n = this.query(sql).getJSONObject(0).getInteger("ROWCOUNT");
        return n;
    }

    public long getRowCountLong(String tableOrViewName, String whereString) {
        String sql = "Select count(1) as ROWCOUNT From " + tableOrViewName;
        if (whereString.trim().length() > 0) {
            sql = sql + " Where " + whereString.trim();
        }
        long n = this.query(sql).getJSONObject(0).getLong("ROWCOUNT");
        return n;
    }

    public JSONArray queryPage(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize) {
        if (whereString.trim().length() > 0) {
            whereString = " where " + whereString.trim();
        }
        if (orderBy.trim().length() > 0) {
            orderBy = " Order By " + orderBy;
        }
        String sql = "";
        JSONArray jsonArray = null;
        Statement objState = null;
        try {
            objState = this.getConnection().createStatement();
            sql = this.getPageSQL(tableOrViewOrSQLView, whereString, orderBy, pageNo, pageSize);
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet rs = objState.executeQuery(sql);
            jsonArray = JdbcHelper.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objState);
        }
        return jsonArray;
    }

    public PageInfo queryPageDetails(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize) {
        JSONArray jsonArray;
        if (whereString.trim().length() > 0) {
            whereString = " where " + whereString.trim();
        }
        if (orderBy.trim().length() > 0) {
            orderBy = " Order By " + orderBy;
        }
        String sql = "";
        long totalCount = 0L;
        long pageCount = 0L;
        Statement objState = null;
        try {
            objState = this.getConnection().createStatement();
            sql = this.getPageSQL(tableOrViewOrSQLView, whereString, orderBy, pageNo, pageSize);
            this.logger.debug("SQL_Debug : " + sql);
            ResultSet rs = objState.executeQuery(sql);
            jsonArray = JdbcHelper.resultSetToJSONArray(rs);
            sql = "Select count(1) as ROWCOUNT From " + tableOrViewOrSQLView + whereString;
            ResultSet rsCount = objState.executeQuery(sql);
            rsCount.next();
            totalCount = rsCount.getLong(1);
            pageCount = totalCount / (long)pageSize;
            if (totalCount % (long)pageSize > 0L) {
                ++pageCount;
            }
        }
        catch (Exception ex) {
            this.logger.error("SQL_Error : " + sql, (Throwable)ex);
            throw new RuntimeException(ex);
        }
        finally {
            this.closeStatement(objState);
        }
        PageInfo page = new PageInfo();
        page.totalCount = totalCount;
        page.pageCount = pageCount;
        page.pageSize = pageSize;
        page.currentPageNo = pageNo;
        page.pageData = jsonArray;
        return page;
    }

    private String getPageSQL(String tableOrViewOrSQLView, String whereString, String orderBy, int pageNo, int pageSize) {
        StringBuffer sb = new StringBuffer();
        if (this.getDBType().equals("mssql")) {
            sb.append("Select top " + pageSize + " * From ");
            sb.append(" (select ROW_NUMBER() OVER ( " + orderBy + " ) as RowNo,*  from " + tableOrViewOrSQLView + " " + whereString + " ) v1 ");
            sb.append(" where RowNo> " + (pageNo - 1) * pageSize);
        } else if (this.getDBType().equals("oracle")) {
            sb.append("SELECT * FROM ( SELECT ROWNUM Table_RowNum , db_pagesql_view1.* FROM " + tableOrViewOrSQLView + " db_pagesql_view1 " + whereString + " ) db_pagesql_view2  WHERE Table_RowNum <= " + pageNo * pageSize + " and Table_RowNum > " + (pageNo - 1) * pageSize + orderBy);
        } else if (this.getDBType().equals("dm")) {
            sb.append("SELECT * FROM ( SELECT ROWNUM Table_RowNum , db_pagesql_view1.* FROM " + tableOrViewOrSQLView + " db_pagesql_view1 " + whereString + " ) db_pagesql_view2  WHERE Table_RowNum <= " + pageNo * pageSize + " and Table_RowNum > " + (pageNo - 1) * pageSize + orderBy);
        } else if (this.getDBType().equals("mysql")) {
            sb.append("SELECT * FROM " + tableOrViewOrSQLView + whereString + orderBy + " limit " + pageSize + " offset " + (pageNo - 1) * pageSize);
        } else if (this.getDBType().equals("sqlite")) {
            sb.append("SELECT * FROM " + tableOrViewOrSQLView + whereString + orderBy + " limit " + pageSize + " offset " + (pageNo - 1) * pageSize);
        }
        return sb.toString();
    }

    public void commit() throws Exception {
        this.getConnection().commit();
    }

    public void rollback() {
        try {
            this.getConnection().rollback();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void close() {
        try {
            this.getConnection().close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void commitAndClose() throws Exception {
        this.commit();
        this.close();
    }

    public void insert(T entity) throws RuntimeException {
        BuildExecSQL.BuildResultType rt = this.build.BuildExeSQLInsert(entity);
        this.executeUpdate(rt.sql, rt.prams);
    }

    public void update(T entity) throws RuntimeException {
        BuildExecSQL.BuildResultType rt = this.build.BuildExeSQLUpdate(entity);
        this.executeUpdate(rt.sql, rt.prams);
    }

    public void delete(Class entityClass, String filter) throws RuntimeException {
        String sql = this.build.BuildExeSQLDelete(entityClass, filter);
        this.executeUpdate(sql, null);
    }

    public List<HashMap<String, Object>> resultSetToMapList(ResultSet rs) throws Exception {
        ArrayList<HashMap<String, Object>> list = new ArrayList<HashMap<String, Object>>();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String sColumnName = md.getColumnName(i);
                String sColumnClassName = md.getColumnClassName(i);
                String key_name = sColumnName.toLowerCase();
                if (sColumnClassName.toUpperCase().indexOf("CLOB") > 0) {
                    try {
                        Clob clob = (Clob)rs.getObject(sColumnName);
                        String value1 = this.ClobToString(clob);
                        hashMap.put(key_name, value1);
                    }
                    catch (Exception ex1) {
                        ex1.printStackTrace();
                    }
                    continue;
                }
                hashMap.put(key_name, rs.getObject(sColumnName));
            }
            list.add(hashMap);
        }
        return list;
    }

    public String ClobToString(Clob clob) throws Exception {
        String result = clob.getSubString(1L, 0xA00000);
        return result;
    }
}

