/*
 * Decompiled with CFR 0.152.
 */
package cn.liboss.ass.core;

import cn.liboss.ass.core.FileUtil;
import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;

public class JdbcHelper {
    public static boolean isPrintSql = false;
    public static boolean isPoolOrJdbc = true;
    public static String jdbcDriver = "";
    public static String jdbcConnURL = "";
    public static String jdbcUserName = "";
    public static String jdbcPassWord = "";
    private static int initialSize = 1;
    private static int minIdle = 3;
    private static int maxActive = 100;
    private static int maxWait = 10000;
    private static int minEvictableIdleTimeMillis = 600000;
    private static DataSource dataSource = null;

    private static String getNowTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date());
    }

    public static DataSource getDataSource() throws Exception {
        if (dataSource == null) {
            String default_db_prefix = FileUtil.getSystemProperties("default_db");
            jdbcDriver = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.driver");
            jdbcConnURL = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.url");
            jdbcUserName = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.username");
            jdbcPassWord = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.password");
            DruidDataSource druid_ds = new DruidDataSource();
            druid_ds.setDriverClassName(jdbcDriver);
            druid_ds.setUrl(jdbcConnURL);
            if (!jdbcUserName.equals("")) {
                druid_ds.setUsername(jdbcUserName);
                druid_ds.setPassword(jdbcPassWord);
                druid_ds.setInitialSize(initialSize);
                druid_ds.setMinIdle(minIdle);
                druid_ds.setMaxActive(maxActive);
                druid_ds.setMinEvictableIdleTimeMillis((long)minEvictableIdleTimeMillis);
            }
            dataSource = druid_ds;
        }
        return dataSource;
    }

    public static Connection getConnection() throws Exception {
        Connection objConn = null;
        objConn = isPoolOrJdbc ? JdbcHelper.getPoolConnection() : JdbcHelper.getJdbcConnection();
        return objConn;
    }

    public static Connection getPoolConnection() throws Exception {
        Connection objConn;
        try {
            objConn = JdbcHelper.getDataSource().getConnection();
        }
        catch (Exception ex) {
            dataSource = null;
            throw ex;
        }
        return objConn;
    }

    public static Connection getJdbcConnection() throws Exception {
        if (jdbcDriver == null || jdbcDriver.length() <= 0) {
            String default_db_prefix = FileUtil.getSystemProperties("default_db");
            jdbcDriver = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.driver");
            jdbcConnURL = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.url");
            jdbcUserName = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.username");
            jdbcPassWord = FileUtil.getSystemProperties(default_db_prefix + ".jdbc.password");
        }
        Connection objConn = null;
        Class.forName(jdbcDriver);
        objConn = jdbcUserName == null || jdbcUserName.equals("") ? DriverManager.getConnection(jdbcConnURL) : DriverManager.getConnection(jdbcConnURL, jdbcUserName, jdbcPassWord);
        return objConn;
    }

    public static int executeUpdate(String sql) {
        int count = JdbcHelper.executeUpdate(sql, null);
        return count;
    }

    public static int executeUpdate(String sql, List pramValues) {
        Connection objConn = null;
        PreparedStatement objPreState = null;
        int count = 0;
        try {
            objConn = JdbcHelper.getConnection();
            objPreState = objConn.prepareStatement(sql);
            if (pramValues != null) {
                for (int i = 0; i < pramValues.size(); ++i) {
                    objPreState.setObject(i + 1, pramValues.get(i));
                }
            }
            if (isPrintSql) {
                if (pramValues == null) {
                    System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Debug : " + sql);
                } else {
                    System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Debug : " + sql + pramValues.toString());
                }
            }
            count = objPreState.executeUpdate();
        }
        catch (Exception ex) {
            if (pramValues == null) {
                System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Error : " + sql);
            } else {
                System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Error : " + sql + pramValues.toArray());
            }
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (objConn != null) {
                    objConn.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return count;
    }

    public static void executeUpdateBatch(String sql, List<List> paramsValuesArray) {
        Connection objConn = null;
        PreparedStatement objPreState = null;
        try {
            objConn = JdbcHelper.getConnection();
            objConn.setAutoCommit(false);
            if (isPrintSql) {
                if (paramsValuesArray == null) {
                    System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Debug : " + sql);
                } else {
                    System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Debug : " + sql + ",parmsValues_size=" + paramsValuesArray.size());
                }
            }
            objPreState = objConn.prepareStatement(sql);
            for (int m = 0; m < paramsValuesArray.size(); ++m) {
                List params = paramsValuesArray.get(m);
                if (params != null) {
                    for (int i = 0; i < params.size(); ++i) {
                        objPreState.setObject(i + 1, params.get(i));
                    }
                }
                objPreState.addBatch();
            }
            objPreState.executeBatch();
            objConn.commit();
        }
        catch (Exception ex) {
            if (paramsValuesArray == null) {
                System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Error : " + sql);
            } else {
                System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Error : " + sql + paramsValuesArray.toArray());
            }
            throw new RuntimeException(ex);
        }
        finally {
            try {
                if (objConn != null) {
                    objConn.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static ResultSet getResultSet(String sql) {
        return JdbcHelper.getResultSet(sql, null);
    }

    public static ResultSet getResultSet(String sql, List paramValues) {
        Connection objConn = null;
        PreparedStatement objPreState = null;
        try {
            ResultSet objRS;
            objConn = JdbcHelper.getConnection();
            objPreState = objConn.prepareStatement(sql);
            if (paramValues != null) {
                for (int i = 0; i < paramValues.size(); ++i) {
                    objPreState.setObject(i + 1, paramValues.get(i));
                }
            }
            if (isPrintSql) {
                if (paramValues == null) {
                    System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Debug : " + sql);
                } else {
                    System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Debug : " + sql + paramValues);
                }
            }
            ResultSet resultSet = objRS = objPreState.executeQuery();
            return resultSet;
        }
        catch (Exception ex) {
            System.out.println("[" + JdbcHelper.getNowTime() + "] SQL_Error : " + sql);
            throw new RuntimeException(ex);
        }
    }

    public static void printColumnInfo(String tableOrViewName) throws Exception {
        ResultSet rs = JdbcHelper.getResultSet("select * from " + tableOrViewName);
        ResultSetMetaData md = rs.getMetaData();
        System.out.println("printColumnInfo:");
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            String s = "ColumnLabel : " + md.getColumnLabel(i) + " , ColumnName : " + md.getColumnName(i) + " , \t\tColumnClassName : " + md.getColumnClassName(i) + " , \tColumnTypeName : " + md.getColumnTypeName(i) + " , ColumnType : " + md.getColumnType(i) + " , ColumnDisplaySize : " + md.getColumnDisplaySize(i) + " , Scale : " + md.getScale(i) + " , Precision : " + md.getPrecision(i);
            System.out.println(s);
        }
        rs.close();
        System.out.println("--------------------------------");
    }

    public static JSONArray query(String sql) throws Exception {
        ResultSet rs = null;
        JSONArray jsonArray = null;
        try {
            rs = JdbcHelper.getResultSet(sql);
            jsonArray = JdbcHelper.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        return jsonArray;
    }

    public static JSONArray query(String sql, List pramValues) throws Exception {
        ResultSet rs = null;
        JSONArray jsonArray = null;
        try {
            rs = JdbcHelper.getResultSet(sql, pramValues);
            jsonArray = JdbcHelper.resultSetToJSONArray(rs);
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        return jsonArray;
    }

    public static JSONArray resultSetToJSONArray(ResultSet rs) throws Exception {
        JSONArray jsonArray = new JSONArray();
        ResultSetMetaData md = rs.getMetaData();
        while (rs.next()) {
            JSONObject json = new JSONObject();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                String sColumnName = md.getColumnName(i);
                String sColumnClassName = md.getColumnClassName(i);
                String sColumnTypeName = md.getColumnTypeName(i);
                String key_name = sColumnName.toLowerCase();
                if (sColumnClassName.equals("java.lang.String") || sColumnClassName.equals("java.lang.Boolean") || sColumnClassName.equals("java.sql.Timestamp") || sColumnClassName.equals("java.util.Date") || sColumnClassName.equals("java.lang.Float") || sColumnClassName.equals("java.lang.Double") || sColumnClassName.equals("java.lang.Integer") || sColumnClassName.equals("java.lang.Short") || sColumnClassName.equals("java.lang.Byte") || sColumnClassName.equals("java.lang.Long") || sColumnClassName.equals("java.math.BigDecimal")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                if (sColumnClassName.equals("oracle.sql.INTERVALDS") || sColumnClassName.equals("oracle.sql.INTERVALYM") || sColumnClassName.equals("oracle.sql.TIMESTAMP") || sColumnClassName.equals("oracle.sql.TIMESTAMPLTZ") || sColumnClassName.equals("oracle.sql.TIMESTAMPTZ")) {
                    json.put((Object)key_name, (Object)rs.getTimestamp(i));
                    continue;
                }
                if (sColumnClassName.equals("oracle.sql.BINARY_DOUBLE") || sColumnClassName.equals("oracle.sql.BINARY_FLOAT")) {
                    json.put((Object)key_name, (Object)rs.getBigDecimal(i));
                    continue;
                }
                if (sColumnClassName.equals("oracle.jdbc.OracleClob") || sColumnClassName.equals("oracle.jdbc.OracleNClob")) {
                    Clob clob = (Clob)rs.getObject(sColumnName);
                    if (clob != null) {
                        String value1 = JdbcHelper.clobToString(clob);
                        json.put((Object)key_name, (Object)value1);
                        continue;
                    }
                    json.put((Object)key_name, (Object)clob);
                    continue;
                }
                if (sColumnClassName.equals("oracle.jdbc.OracleBlob")) {
                    Blob blob = (Blob)rs.getObject(sColumnName);
                    if (blob != null) {
                        byte[] byte1 = JdbcHelper.BlobToBytes(blob);
                        json.put((Object)key_name, (Object)byte1);
                        continue;
                    }
                    json.put((Object)key_name, (Object)blob);
                    continue;
                }
                if (sColumnClassName.equals("java.lang.Object") && sColumnTypeName.trim().equals("TEXT")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                if (sColumnClassName.equals("java.lang.Object") && sColumnTypeName.trim().equals("NUMERIC")) {
                    json.put((Object)key_name, rs.getObject(sColumnName));
                    continue;
                }
                json.put((Object)key_name, rs.getObject(sColumnName));
                String value = null;
                if (rs.getObject(sColumnName) != null) {
                    value = rs.getObject(sColumnName).toString();
                }
                System.out.println("\u672a\u5b9a\u4e49\u7684jdbc\u7c7b\u578b\u6620\u5c04:ColumnName=" + sColumnName + ",ColumnClassName=" + sColumnClassName + ",ColumnTypeName=" + sColumnTypeName + ", value=" + value);
            }
            jsonArray.add((Object)json);
        }
        return jsonArray;
    }

    public static String clobToString(Clob clob) throws SQLException, IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        Reader reader = clob.getCharacterStream();
        BufferedReader br = new BufferedReader(reader);
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        return sb.toString();
    }

    public static byte[] BlobToBytes(Blob blob) throws Exception {
        byte[] result = blob.getBytes(1L, 0xA00000);
        return result;
    }
}

