/*
 * Decompiled with CFR 0.152.
 */
package cn.leyekeji.store.task;

import cn.leyekeji.store.task.JobTaskProperties;
import java.util.concurrent.Executor;
import java.util.logging.Logger;
import org.springframework.aop.interceptor.AsyncUncaughtExceptionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

@ConditionalOnProperty(name={"leyekeji.store.task.open"}, havingValue="true")
@Configuration
@EnableScheduling
@ComponentScan(value={"cn.leyekeji.store.task.jobAnno.aspect"})
@Role(value=2)
public class JobTaskEnableConfig
implements SchedulingConfigurer,
AsyncConfigurer {
    private Logger logger = Logger.getLogger("StoreJobTaskConfig");
    @Autowired
    private JobTaskProperties jobTaskProperties;

    @Bean
    public ThreadPoolTaskScheduler taskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.initialize();
        scheduler.setPoolSize(this.jobTaskProperties.getCorePoolSize().intValue());
        scheduler.setThreadNamePrefix("TaskScheduler-");
        return scheduler;
    }

    public Executor getAsyncExecutor() {
        ThreadPoolTaskScheduler executor = this.taskScheduler();
        return executor;
    }

    public AsyncUncaughtExceptionHandler getAsyncUncaughtExceptionHandler() {
        return null;
    }

    public void configureTasks(ScheduledTaskRegistrar scheduledTaskRegistrar) {
        scheduledTaskRegistrar.setTaskScheduler((TaskScheduler)this.taskScheduler());
        this.logger.warning("\u5b9a\u65f6\u4efb\u52a1\u529f\u80fd\u5df2\u5f00\u542f,\u4f7f\u7528\u65f6\u8bf7\u52a1\u5fc5\u7ee7\u627fJobTask\u7c7b");
    }
}

