/*
 * Decompiled with CFR 0.152.
 */
package cn.leyekeji.common.util;

import java.math.BigDecimal;

public class PriceHelperUtil {
    public static final String CURRENCY_YUAN_REGEX = "^(([0-9]|([1-9][0-9]{0,9}))((.[0-9]{1,2})?))$";
    public static final String CURRENCY_FEN_REGEX = "\\-?[0-9]+";

    public static BigDecimal fen2Yuan(String amount) {
        if (!amount.matches(CURRENCY_FEN_REGEX)) {
            throw new RuntimeException("\u91d1\u989d\u683c\u5f0f\u9519\u8bef|" + amount);
        }
        return BigDecimal.valueOf(Long.valueOf(amount)).divide(new BigDecimal(100));
    }

    public static BigDecimal fen2Yuan(int amount) {
        if (!String.valueOf(amount).matches(CURRENCY_FEN_REGEX)) {
            throw new RuntimeException("\u91d1\u989d\u683c\u5f0f\u9519\u8bef|" + amount);
        }
        return BigDecimal.valueOf(amount).divide(new BigDecimal(100));
    }

    public static BigDecimal fen2Yuan(Long amount) {
        if (!String.valueOf(amount).matches(CURRENCY_FEN_REGEX)) {
            throw new RuntimeException("\u91d1\u989d\u683c\u5f0f\u9519\u8bef|" + amount);
        }
        return BigDecimal.valueOf(amount).divide(new BigDecimal(100));
    }

    public static String fen2YuanStr(String amount) {
        if (!amount.matches(CURRENCY_FEN_REGEX)) {
            throw new RuntimeException("\u91d1\u989d\u683c\u5f0f\u9519\u8bef|" + amount);
        }
        return BigDecimal.valueOf(Long.valueOf(amount)).divide(new BigDecimal(100)).toString();
    }

    public static int yuan2FenInt(String yuan) {
        BigDecimal fenBd = new BigDecimal(yuan).multiply(new BigDecimal(100));
        fenBd = fenBd.setScale(0, 4);
        return fenBd.intValue();
    }

    public static Integer fen2YuanInt(Integer amount) {
        return BigDecimal.valueOf(amount.intValue()).divide(new BigDecimal(100)).setScale(0, 1).intValue();
    }

    public static String fen2YuanStr(int amount) {
        return BigDecimal.valueOf(amount).divide(new BigDecimal(100)).toString();
    }

    public static String fen2YuanStr(int amount, int keep) {
        return BigDecimal.valueOf(amount).divide(new BigDecimal(100)).setScale(keep, 4).toString();
    }

    public static void main(String[] args) {
        int amount = 1020;
        String yuan = "102";
        System.out.println(PriceHelperUtil.fen2YuanStr(yuan));
    }
}

