/*
 * Decompiled with CFR 0.152.
 */
package cn.leyekeji.common.util;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.util.ClassUtils;

public class ChangeEntry {
    private Map<String, ?> oldMap;

    public ChangeEntry() {
    }

    public ChangeEntry(Map<String, ?> oldMap) {
        this.oldMap = oldMap;
    }

    public ChangeEntry(Object oldObj) {
        this.setOld(oldObj);
    }

    public void setOld(Object oldObj) {
        if (oldObj != null) {
            this.oldMap = this.beanToMap(oldObj);
        }
        if (this.oldMap == null) {
            this.oldMap = new HashMap();
        }
    }

    public Map<String, String> getChangeMap(Object newObj) {
        HashMap tmpMap = new HashMap(this.oldMap);
        Map<String, Object> newMap = this.beanToMap(newObj);
        if (newMap == null) {
            newMap = new HashMap<String, Object>();
        }
        HashMap<String, String> changeMap = new HashMap<String, String>();
        ArrayList<Object> keySet = new ArrayList<Object>();
        keySet.addAll(tmpMap.keySet());
        keySet.addAll(newMap.keySet());
        for (String string : keySet) {
            String nv;
            Object oldvalue = tmpMap.remove(string);
            Object newvalue = newMap.remove(string);
            String ov = this.getStringValue(oldvalue);
            if (StringUtils.equals((String)ov, (String)(nv = this.getStringValue(newvalue)))) continue;
            changeMap.put(string, ov + "==>" + nv);
        }
        return changeMap;
    }

    public int getChangeMapSize(Object newObj) {
        Map<String, String> map = this.getChangeMap(newObj);
        return map.size();
    }

    public String getChangeMap(Map<String, String> changeMap) {
        if (changeMap.isEmpty()) {
            return "";
        }
        String change = changeMap.toString();
        return change;
    }

    public String getStringValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (ClassUtils.isPrimitiveOrWrapper(value.getClass())) {
            return "" + value;
        }
        if (value instanceof LocalDateTime) {
            return DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm").format((LocalDateTime)value);
        }
        return value instanceof LocalDate ? DateTimeFormatter.ofPattern("yyyy-MM-dd").format((LocalDate)value) : "" + value;
    }

    public <T> Map<String, Object> beanToMap(T bean) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (bean != null) {
            BeanMap beanMap = BeanMap.create(bean);
            for (Object key : beanMap.keySet()) {
                map.put(key + "", beanMap.get(key));
            }
        }
        return map;
    }
}

