/*
 * Decompiled with CFR 0.152.
 */
package cn.leyekeji.common.result;

import cn.leyekeji.common.base.BaseSerializable;
import org.apache.commons.lang.StringUtils;

public class ResultCode<T>
extends BaseSerializable {
    private static final String successCode = "0000";
    private static final String errorCode = "9999";
    private String code;
    private String msg;
    private T data;
    private boolean success = false;

    private ResultCode(String code, T data, String msg) {
        this.code = code;
        this.data = data;
        this.msg = msg;
        this.success = StringUtils.equals((String)code, (String)successCode);
    }

    public static <T> ResultCode<T> getSuccess() {
        return ResultCode.getSuccessReturn(null);
    }

    public static <T> ResultCode<T> getSuccessReturn(T data) {
        return ResultCode.getReturn(successCode, "\u64cd\u4f5c\u6210\u529f", data);
    }

    public static <T> ResultCode<T> getFailure() {
        return ResultCode.getFailure("\u64cd\u4f5c\u5931\u8d25");
    }

    public static <T> ResultCode<T> getFailure(String msg) {
        return ResultCode.getFailure(errorCode, msg);
    }

    public static <T> ResultCode<T> getFailure(String code, String msg) {
        return ResultCode.getReturn(code, msg, null);
    }

    private static <T> ResultCode<T> getReturn(String code, String msg, T data) {
        return new ResultCode<T>(code, data, msg);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getErrcode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }
}

